<?php

namespace App\Models\Users\Resellers;

use Illuminate\Database\Eloquent\Model;
use DB;

class Category extends Model
{
    public static $client_id;
    protected $group;

    public function __construct($client_id = null, array $attributes = array())
    {
        $this->client_id = $client_id;
        parent::__construct($attributes);
    }

    //
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = ['created_at', 'updated_at', 'deactivated', 'visible_individual'];

    /**
     * Get the groups that belongs to this category.
     */
    public function groups()
    {
        return $this->hasMany('App\Models\Users\Resellers\Group');
    }

    /**
     * Get the groups with standard products that belongs to this category.
     */
    public function standardProductsGroups()
    {
        return $this->getGroupCommonQuery()
                    ->whereHas('standardProductsCondition')
                    ->with(['pictures','standardProducts'=>function($query) {
                        $this->getProductWithFavouriteCommonQuery($query)
                            ->where('non_standard', 0)
                            ->where('specific_client_id', null)
                            //->orderBy('ERP_code','ASC');
                            ->orderBy('length', 'ASC')
                            ->orderBy('width', 'ASC')
                            ->orderBy('high', 'ASC');

                    }])
                    ->orderBy('name');
    }

    /**
     * Get the groups with standard products that belongs to this category.
     */
    public function nonStandardProductsGroups()
    {
        return $this->getGroupCommonQuery()
                    ->whereHas('nonStandardProductsCondition')
                    ->with(['pictures','nonStandardProducts'=>function($query) {
                        $this->getProductCommonQuery($query)
                            ->where('non_standard', 1)
                            ->where('specific_client_id', null)
                            ->orderBy('ERP_code', 'ASC');

                        }])
                    ->orderBy('name');
    }


    /**
     * Get the groups with specific products that belongs to this category.
     */
    public function specificProductsGroups()
    {
        return $this->getGroupCommonQuery()
                    ->whereHas('specificProducts', function($query){
                        $query->where('deactivated', 0)
                              ->where('specific_client_id',$this->client_id);
                    })
                    ->with(['pictures','specificProducts'=>function($query){
                        $this->getProductCommonQuery($query)
                            ->where('specific_client_id',$this->client_id)
                            //->orderBy('ERP_code','ASC');
                            ->orderBy('length', 'ASC')
                            ->orderBy('width', 'ASC')
                            ->orderBy('high', 'ASC');

                    }])
                    ->orderBy('name');
    }

    /**
     * Get the groups with favourite products that belongs to this category.
     */
    public function favouriteProductsGroups()
    {
        return $this->getGroupCommonQuery()
            ->whereHas('favouriteProducts', function($query){
                $this->getProductFavouriteQuery($query)
                     ->where('products.deactivated', 0);
            })
            ->with(['pictures','favouriteProducts'=>function($query){
                $this->getProductFavouriteQuery($query)
                    //->orderBy('ERP_code','ASC');
                    ->orderBy('length', 'ASC')
                    ->orderBy('width', 'ASC')
                    ->orderBy('high', 'ASC');
            }])
            ->orderBy('name');
    }

    private function getGroupCommonQuery() {
        return

            /*
             $this->hasMany('App\Models\Users\Resellers\Group')
               ->where('deactivated', 0);
             */

            $this->hasMany('App\Models\Users\Resellers\Group')
                    ->select('groups.id', 'groups.deactivated', 'groups.ERP_code', DB::raw('(CASE WHEN client_group.reference_name is not null THEN client_group.reference_name ELSE groups.name END) as name'), 'groups.category_id', 'groups.picture', 'groups.description_short', 'groups.description_detailled', 'groups.sans_dims')
                    ->leftJoin('client_group', function ($join)  {
                        $join->on('client_group.group_id', '=', 'groups.id')
                            ->where('client_group.client_id', '=', $this->client_id);
                     })
                    ->where('groups.deactivated', 0);
    }

    private function getProductCommonQuery($query) {
        return
           /*
            $query->select('products.*','discounts.ERP_group_code', 'client_discount.rate as discount_rate')
                ->leftJoin('discounts','products.discount_id','=','discounts.id')
                ->leftJoin('client_discount', function ($join)  {
                    $join->on('products.discount_id', '=', 'client_discount.discount_id')
                        ->where('client_discount.client_id', '=', $this->client_id);
                })
                ->where('products.deactivated', 0);
            */

            $query->select('products.id', 'products.created_at', 'products.updated_at', 'products.deactivated', 'products.visible_individual', 'products.group_id', db::raw('(CASE WHEN client_product.reference_name IS NOT NULL THEN client_product.reference_name ELSE products.name END) AS name'), 'products.ERP_code', 'products.non_standard', 'products.is_gabarit', 'products.unit_id', 'products.type_id','products.saisir_longueur','products.length','products.saisir_largeur', 'products.width', 'products.saisir_hauteur','products.high','products.saisir_dim_supp_1','products.label_dim_supp_1','products.saisir_dim_supp_2','products.label_dim_supp_2','products.saisir_dim_supp_3','products.label_dim_supp_3','products.saisir_dim_supp_4','products.label_dim_supp_4','products.saisir_dim_supp_5','products.label_dim_supp_5','products.saisir_info_supp_1','products.label_info_supp_1','products.saisir_info_supp_2','products.label_info_supp_2','products.price_ttc', 'products.price_attr1', 'products.price_attr2', 'products.price_attr3','products.vat_id', 'products.discount_id','products.specific_client_id',
                            db::raw('discounts.ERP_group_code as discount_ERP_group_code'), db::raw('client_discount.rate  as  discount_rate'),
                            db::raw('CalculateDimensions(products.saisir_longueur,products.length,products.saisir_largeur,products.width,products.saisir_hauteur,products.high,products.name,client_product.reference_name,types.name) as dimensions'),
                            db::raw('types.name as type_name'))
                    ->leftJoin('discounts','products.discount_id','=','discounts.id')
                    ->leftJoin('client_discount', function ($join)  {
                        $join->on('products.discount_id', '=', 'client_discount.discount_id')
                            ->where('client_discount.client_id', '=', $this->client_id);
                    })
                    ->leftJoin('client_product', function ($join)  {
                        $join->on('client_product.product_id', '=', 'products.id')
                            ->where('client_product.client_id', '=', $this->client_id);
                    })
                    ->leftJoin('types','products.type_id','=','types.id')
                    ->where('products.deactivated', 0);
    }

    private function getProductWithFavouriteCommonQuery($query) {
        return
            $query->select('products.id', 'products.created_at', 'products.updated_at', 'products.deactivated', 'products.visible_individual', 'products.group_id', db::raw('(CASE WHEN client_product.reference_name IS NOT NULL THEN client_product.reference_name ELSE products.name END) AS name'), 'products.ERP_code', 'products.non_standard', 'products.is_gabarit', 'products.unit_id', 'products.type_id','products.saisir_longueur','products.length','products.saisir_largeur', 'products.width', 'products.saisir_hauteur','products.high','products.saisir_dim_supp_1','products.label_dim_supp_1','products.saisir_dim_supp_2','products.label_dim_supp_2','products.saisir_dim_supp_3','products.label_dim_supp_3','products.saisir_dim_supp_4','products.label_dim_supp_4','products.saisir_dim_supp_5','products.label_dim_supp_5','products.saisir_info_supp_1','products.label_info_supp_1','products.saisir_info_supp_2','products.label_info_supp_2','products.price_ttc',  'products.price_attr1', 'products.price_attr2', 'products.price_attr3', 'products.vat_id', 'products.discount_id','products.specific_client_id',
                db::raw('discounts.ERP_group_code as discount_ERP_group_code'), db::raw('client_discount.rate  as  discount_rate'),
                db::raw('CalculateDimensions(products.saisir_longueur,products.length,products.saisir_largeur,products.width,products.saisir_hauteur,products.high,products.name,client_product.reference_name,types.name) as dimensions'),
                db::raw('types.name as type_name'),
                db::raw('(CASE WHEN favourites.client_id IS NOT NULL THEN "Y" ELSE "N" END) AS is_favourite'))
                ->leftJoin('discounts','products.discount_id','=','discounts.id')
                ->leftJoin('client_discount', function ($join)  {
                    $join->on('products.discount_id', '=', 'client_discount.discount_id')
                        ->where('client_discount.client_id', '=', $this->client_id);
                })
                ->leftJoin('client_product', function ($join)  {
                    $join->on('client_product.product_id', '=', 'products.id')
                        ->where('client_product.client_id', '=', $this->client_id);
                })
                ->leftJoin('favourites', function ($join)  {
                    $join->on('favourites.product_id', '=', 'products.id')
                        ->where('favourites.client_id', '=', $this->client_id);
                })
                ->leftJoin('types','products.type_id','=','types.id')
                ->where('products.deactivated', 0);
    }


    private function getProductFavouriteQuery($query) {
        return
            $this->getProductCommonQuery($query)
                 //->select(db::raw('(CASE WHEN favourites.client_id IS NOT NULL THEN "Y" ELSE "N" END) AS is_favourite'))
                 ->join('favourites', function ($join)  {
                    $join->on('favourites.product_id', '=', 'products.id')
                        ->where('favourites.client_id', '=', $this->client_id);
                 });
    }
}
