<?php

namespace App\Models\Users\Individuals;

use Illuminate\Database\Eloquent\Model;

class Command extends Model
{
    //
    /**
     * The attributes that should be visible for arrays.
     *
     * @var array
     */
    protected $hidden = ['updated_at', 'status_id', 'ERP_code', 'client_id', 'channel_id', 'individual_id', 'reseller_id', 'delivery_id', 'total_ttc', 'total_ht', 'total_vat'];

    protected $appends = ['ttc_total', 'ht_total', 'tva_total'];

    function getTtcTotalAttribute() {
        return number_format($this->total_ttc, 2, ',', ' ');
    }

    function getHtTotalAttribute() {
        return number_format($this->total_ht, 2, ',', ' ');
    }

    function getTvaTotalAttribute() {
        return number_format($this->total_vat, 2, ',', ' ');
    }

    /**
     * Get the channel that this command belongs to.
     */
    public function channel()
    {
        return $this->belongsTo('App\Models\Users\Channel');
    }

    /**
     * Get the status that this command belongs to.
     */
    public function status()
    {
        return $this->belongsTo('App\Models\Status');
    }

    /**
     * Get the delivery information that this command belongs to.
     */
    public function delivery()
    {
        return $this->belongsTo('App\Models\Users\Delivery');
    }

    /**
     * Get the items that belongs to this command.
     */
    public function items()
    {
        return $this->hasMany('App\Models\Users\Individuals\Item');
    }

}
