<?php

namespace App\Models\Users;

use Illuminate\Database\Eloquent\Model;

class Group extends Model
{
    //
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = ['created_at', 'updated_at', 'deactivated', 'visible_individual', 'category_id'];

    /**
     * Get the category that the group belongs to.
     */
    public function category()
    {
        return $this->belongsTo('App\Models\Users\Category');
    }

    /**
     * Get the products that belongs to this group.
     */
    public function products()
    {
        return $this->hasMany('App\Models\Users\Product');
    }
}
