<?php

namespace App\Models\ERP;

use Illuminate\Database\Eloquent\Model;

class Item extends Model
{
    //
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = ['id', 'created_at', 'updated_at', 'command_id', 'product_id', 'variant_id', 'client_id', 'high', 'product_type_id'];

    /**
     * The attributes that should be appended to arrays.
     *
     * @var array
     */
    protected $appends = ['height'];

    /**
     * Get the Discount Rate.
     *
     * @return Integer
     */
    public function getDiscountRateAttribute($value)
    {
        if ($value == null)
            return 0;
        else
            return $value;
    }

    /**
     * Get the Height.
     *
     * @return Integer
     */
    public function getHeightAttribute()
    {
        return $this->high;
    }
}
