<?php

namespace App\Models\ERP;

use Illuminate\Database\Eloquent\Model;

class Individual extends Model
{
    //
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = ['id', 'created_at', 'updated_at', 'deactivated', 'user_id', 'client_id', 'civility_id', 'first_name', 'last_name', 'mobile', 'landphone', 'adress', 'adress_followup', 'zip_code', 'town'];

    /**
     * The attributes that should be appended to arrays.
     *
     * @var array
     */
    protected $appends = ['phone', 'full_name', 'full_adress'];

    /**
     * Get the user that this individual belongs to.
     */
    public function user()
    {
        return $this->belongsTo('App\User');
    }

    /**
     * Get the client that this individual belongs to.
     */
    public function client()
    {
        return $this->belongsTo('App\Models\Admin\Client');
    }

    /**
     * Get the civilitiy that this individual belongs to.
     */
    public function civility()
    {
        return $this->belongsTo('App\Models\Admin\Civility');
    }

   /**
     * Get the calculated individual's name.
     */
    public function getFullNameAttribute() {
        return $this->last_name . ' ' . $this->first_name;
    }

    /**
     * Get the calculated individual's phone.
     */
    public function getPhoneAttribute() {
        if ($this->mobile != null)
            return $this->mobile;
        else if ($this->landphone)
            return $this->landphone;
    }

    /**
     * Get the calculated individual's adress.
     */
    public function getFullAdressAttribute() {
        $adress = '';
        if ($this->adress != null)
            $adress = $this->adress;
        else if ($this->adress_followup)
            $adress .= ' ' . $this->adress_followup;
        else if ($this->town)
            $adress .= ' ' . $this->town;

        return $adress;
    }
}
