<?php

namespace App\Models\ERP;

use Illuminate\Database\Eloquent\Model;
use Log;


class Command extends Model
{
    //
    /**
     * The attributes that should be visible for arrays.
     *
     * @var array
     */
    protected $hidden = ['transaction_number','client_id', 'individual_id', 'reseller_id', 'delivery_id', 'client' , 'channel', 'reseller'];

    /**
     * The attributes that should be appended to arrays.
     *
     * @var array
     */
    protected $appends = ['client_code', 'employee_code'];

    /**
     * Get the channel that this command belongs to.
     */
    public function channel()
    {
        return $this->belongsTo('App\Models\ERP\Channel');
    }

    /**
     * Get the status that this command belongs to.
     */
    public function status()
    {
        return $this->belongsTo('App\Models\ERP\Status');
    }

    /**
     * Get the individual that this command belongs to.
     */
    public function individual()
    {
        return $this->belongsTo('App\Models\ERP\Individual');
    }

    /**
     * Get the reseller that this command belongs to.
     */
    public function reseller()
    {
        return $this->belongsTo('App\Models\ERP\Reseller');
    }

    /**
     * Get the client that this command belongs to.
     */
    public function client()
    {
        return $this->belongsTo('App\Models\ERP\Client');
    }

    /**
     * Get the calculated command's client code.
     */
    public function getClientCodeAttribute() {
        if ($this->client != null)
            return $this->client->ERP_code;
        else
            return null;
    }

    /**
     * Get the client that this command belongs to.
     */
    public function user()
    {
        return $this->belongsTo('App\User');
    }

    /**
     * Get the calculated command's Employee Code.
     */
    public function getEmployeeCodeAttribute()
    {
        if ($this->channel->id == 2)
            return $this->reseller->user->email;
        else
            return null;
    }

    /**
     * Get the delivery information that this command belongs to.
     */
    public function delivery()
    {
        //return $this->belongsTo('App\Models\Admin\Delivery');

        // TODO: Check why this is called only for the first returned command.
        //Log::debug('delivery_id.: '.$this->getAttribute('delivery_id').', individual_id.: '.$this->getAttribute('individual_id').', reseller_id.: '.$this->getAttribute('reseller_id'));
        if ($this->getAttribute('delivery_id') != null)
            return $this->belongsTo('App\Models\ERP\Delivery', 'delivery_id');
        else if ($this->getAttribute('individual_id') != null)
            return $this->belongsTo('App\Models\ERP\Individual', 'individual_id');
        else
            return $this->belongsTo('App\Models\ERP\Reseller', 'reseller_id');
    }

    /**
     * Get the items that belongs to this command.
     */
    public function items()
    {
        return $this->hasMany('App\Models\ERP\Item');
    }

}
