<?php

namespace App\Models\ERP;

use Illuminate\Database\Eloquent\Model;

class Client extends Model
{
    //
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = ['id', 'created_at', 'updated_at', 'deactivated'];

    /**
     * Get the individuals that belongs to this client.
     */
    public function resellers()
    {
        return $this->hasMany('App\Models\Admin\Reseller');
    }

    /**
     * Get the individuals that belongs to this client.
     */
    public function individuals()
    {
        return $this->hasMany('App\Models\Admin\Individual');
    }

    /**
     * The discount of this client.
     */
    public function discounts()
    {
        return $this->belongsToMany('App\Models\Admin\Discount')->withPivot('rate')->where('deactivated', 0);
    }
}
