<?php

namespace App\Models\Admin;

use Illuminate\Database\Eloquent\Model;

class Command extends Model
{
    //
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = ['status_id', 'client_id', 'channel_id', 'individual_id', 'reseller_id', 'delivery_id'];

    /**
     * Get the type (Command or Retour) that this command belongs to.
     */
    public function type()
    {
        return $this->belongsTo('App\Models\Admin\CommandType');
    }

    /**
     * Get the channel that this command belongs to.
     */
    public function channel()
    {
        return $this->belongsTo('App\Models\Admin\Channel');
    }

    /**
     * Get the status that this command belongs to.
     */
    public function status()
    {
        return $this->belongsTo('App\Models\Status');
    }

    /**
     * Get the client that this command belongs to.
     */
    public function client()
    {
        return $this->belongsTo('App\Models\Admin\Client');
    }

    /**
     * Get the individual that this command belongs to.
     */
    public function individual()
    {
        return $this->belongsTo('App\Models\Admin\Individual');
    }

    /**
     * Get the reseller that this command belongs to.
     */
    public function reseller()
    {
        return $this->belongsTo('App\Models\Admin\Reseller');
    }

    /**
     * Get the delivery information that this command belongs to.
     */
    public function delivery()
    {
        return $this->belongsTo('App\Models\Admin\Delivery');
    }

    /**
     * Get the items that belongs to this command.
     */
    public function items()
    {
        return $this->hasMany('App\Models\Admin\Item');
    }

}
