<?php

namespace App\Models\Admin;

use Illuminate\Database\Eloquent\Model;

class ResellerCompany extends Model
{
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = ['created_at', 'updated_at', 'client_id'];

    /**
     * Get the client that this reseller belongs to.
     */
    public function client()
    {
        return $this->belongsTo('App\Models\Admin\Client');
    }

    /**
     * The discount of this company reseller.
     */
    public function discounts()
    {
        return $this->client->discounts();
    }

    /**
     * The resellers of this company reseller.
     */
    public function resellers()
    {
        return $this->hasMany('App\Models\Admin\Reseller', 'company_id');
    }

    /**
     * The favourites of this company reseller.
     */
    public function favourites()
    {
        return $this->client->favourites();
    }

    /**
     * The Delivery Addresess of this company reseller.
     */
    public function deliveryAddresses()
    {
        return $this->client->deliveryAddresses();
    }
}
