<?php

namespace App\Models\Admin;

use Illuminate\Database\Eloquent\Model;
use Log;

class Reseller extends Model
{
    //
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = ['created_at', 'updated_at', 'user_id', 'company_id'];

    /**
     * Get the user that this reseller belongs to.
     */
    public function user()
    {
        return $this->belongsTo('App\User');
    }

    /**
     * Get the company that belongs to this reseller.
     */
    public function company()
    {
        return $this->belongsTo('App\Models\Admin\ResellerCompany');
    }
}
