<?php

namespace App\Jobs\Mails\Individuals;

use Illuminate\Contracts\Mail\Mailer;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Log;

class CommandCreated implements ShouldQueue
{
    use InteractsWithQueue, Queueable, SerializesModels;

    protected $email;
    protected $command;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($email, $command)
    {
        //
        $this->email = $email;
        $this->command = $command;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle(Mailer $mailer)
    {
        //
        $command = $this->command;
        $mailer->send('emails.individuals.commands.created', compact('command'), function ($message) {
            if ($this->command->status_id == 1) {
                $message->to($this->email)
                    ->subject('Commande N° ' . $this->command->number . '  est en attente de paiement');
            }
            else if ($this->command->status_id >= 20 && $this->command->status_id != 50) {
                $message->to($this->email)
                    ->subject('Commande N° ' . $this->command->number . ' est confirmée');
            }
        });
    }
}
