<?php

namespace App\Http\Utils;

use Illuminate\Support\Facades\Auth;
use Log;
use Request;

class MyLog
{
    static function merge_arrays ($key, $value)
    {
        return $key .":". $value;
    }

    public static function Warning($status, $error, $message = null, $messages = null) {
        $user = Auth::user();
        // Request
        Log::Warning('BEGIN');
        Log::Warning('Ip:         '.Request::ip());
        if ($user != null)
            Log::Warning('User:       '.$user->email);
        Log::Warning('Path:       '.Request::path());
        Log::Warning('Url:        '.Request::url());
        Log::Warning('Method:     '.Request::method());
        Log::Warning('Parameters: '.Request::getQueryString());
        Log::Warning('Payload:    '.Request::getContent());
        // Response
        Log::Warning('Status:     '.$status);
        Log::Warning('Error:      '.$error);
        if ($message != null)
            Log::Warning('Message:    '.$message);
        if ($messages != null)
            Log::Warning('Messages:   '.'['.implode("|",$messages).']');
        Log::Warning('END');
    }

    public static function Error($status, $error, $message = null, $exception = null, $messages = null, $element = null) {
        $user = Auth::user();
        // Request
        Log::Error('BEGIN');
        Log::Error('Ip:           '.Request::ip());
        if ($user != null)
            Log::Error('User:         '.$user->email);
        Log::Error('Path:         '.Request::path());
        Log::Error('Url:          '.Request::url());
        Log::Error('Method:       '.Request::method());
        Log::Error('Parameters:   '.Request::getQueryString());
        Log::Error('Payload:      '.Request::getContent());
        if ($element != null)
            Log::Error('Element:     ', $element);
        // Response
        Log::Error('Status:       '.$status);
        if ($exception != null)
            Log::Error('Exception:    '.$exception);
        Log::Error('Error:        '.$error);
        if ($message != null)
            Log::Error('Message:      '.$message);
        if ($messages != null)
            Log::Error('Messages:     '.'['.implode("|",$messages).']');
        Log::Error('END');
    }
}

