<?php

namespace App\Http\Middleware;

use Closure;
use App\Http\Utils\MyLog;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;

class Individual
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if ( Auth::check() && Auth::user()->isIndividual() &&  Auth::user()->isVerified())
        {
            return $next($request);
        }
        else {
            $status = 403;
            if (!Auth::user()->isIndividual())
                $error = 'not_individual';
            else if (!Auth::user()->isVerified())
                $error = 'not_confirmed';
            $message = Lang::get('messages.' . $error);
            MyLog::Error($status, $error, $message);
            return response()->json(['error' => $error, 'message' => $message], $status);
        }
    }
}
