<?php

namespace App\Http\Controllers\Api\Users\Resellers\V1_0;

use App\Http\Controllers\Controller;
use App\Models\Users\Resellers\Group;

class GroupController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        return Group::has('products')->get();
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        $group = Group::findOrFail($id);
        $group->category;
        $group->products;
        $group->specifics;
        $group->pictures;

        return $group;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function search($key)
    {
        //
        return Group::with('category', 'products')
                    ->whereHas('products', function ($query) use($key) {
                        $query->where('name', 'like', '%'.$key.'%');
                    })->get();
    }

    /**
     * Display Specific Products.
     *
     * @return \Illuminate\Http\Response
     */
    public function specific()
    {
        //
        return Group::has('specificProducts')->with('specificProducts')->get();
    }
}
