<?php

namespace App\Http\Controllers\Api\Users\Individuals\V1_0;

use App\Http\Controllers\Controller;
use App\Models\Users\Individuals\Category;

class CategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        return Category::where(['deactivated' => 0, 'visible_individual' => 1])->has('groups')->get();
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        $category = Category::where(['deactivated' => 0, 'visible_individual' => 1])->has('groups')->findOrFail($id);
        $category->groups;

        return $category;
    }
}
