<?php

namespace App\Http\Controllers\Api\Admin\V1_0;

use App\Http\Utils\Miscellaneous;
use App\Http\Utils\MyLog;
use App\Http\Controllers\Controller;
use App\Models\Admin\Individual;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Validator;


class IndividualController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $query = Individual::query();

        $inputs = Input::get();
        foreach ($inputs as $key => $value) {
            if ($key != 'page' && $key != 'pagination_per_page') {
                if ($key == 'first_name' ||$key == 'last_name')
                    $query->where('individuals.' . $key,'like', '%'.$value.'%');
                else
                    $query->where('individuals.' . $key,$value);
            }
        }

        if (isset($inputs['pagination_per_page']))
            return $query->with('user', 'client','town')->paginate($inputs['pagination_per_page']);
        else if (!isset($inputs['pagination_per_page']) && isset($inputs['page']))
            return $query->with('user', 'client','town')->paginate();
        else if (!isset($inputs['pagination_per_page']) && !isset($inputs['page']))
            return $query->with('user', 'client','town')->get();
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        //return Individual::findOrFail($id);

        $individual = Individual::findOrFail($id);
        $individual->user;
        $individual->client;
        $individual->civility;
        $individual->town;

        return $individual;
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $warning = null;
        $status = null;

        $validator = Validator::make($request->all(), [
            'first_name' => 'min:3|max:20|regex:/^[(\p{L} \-\')]+$/u',
            'last_name' => 'min:3|max:20|regex:/^[(\p{L} \-\')]+$/u',
            'mobile' => 'digits:10',
            'landphone' => 'digits:10',
            'adress' => 'min:3|max:200|regex:/^[(\d\p{L} \-\',.)]+$/u',
            'zip_code' => 'digits:5',
            'town_id' => 'integer',
            'civility_id' => 'integer'
        ]);

        if ($validator->fails()){
            $status = 400;
            $warning = 'validation_error';
            $messages = $validator->errors()->all();
            MyLog::Warning($status, $warning, null, $messages);
            return response()->json(['error' => $warning, 'messages' => $messages], $status);
        }

        $individual = Individual::findOrFail($id);
        $user = $individual->user;

        /*
        if (Input::has('first_name'))
            $individual->first_name = $request->first_name;
        if (Input::has('last_name'))
            $individual->last_name = $request->last_name;
        if (Input::has('mobile'))
            $individual->mobile = $request->mobile;

        $individuals_count = Individual::where('first_name', $individual->first_name)->where('last_name', $individual->last_name)->count();
        if ($individuals_count > 1)
            $warning = 'user_already_exist_names';
        else {
            $individuals_count = Individual::where('mobile', $individual->mobile)->count();
            if ($individuals_count > 1)
                $warning = 'user_already_exist_mobile';
        }

        if ($warning != null) {
            $status = 409;
            $message = Lang::get('messages.'.$warning);
            MyLog::Warning($request, $status, $warning, $message);
            return response()->json(['error' => $warning, 'message' => $message], $status);
        }
        */

        $inputs = $request->all();
        DB::transaction(function () use ($inputs, $individual, $user) {
            // Individual information storage
            foreach ($inputs as $key => $value) {
                if ($key != 'email' && $key != 'password')
                    $individual[$key] = $value;
                if ($key == 'password') {
                    $user[$key] = Hash::make($value);
                    $user->save();
                }
            }
            $individual->save();
            Miscellaneous::incrementVersion();
        });
    }
}
