<?php

namespace App\Http\Controllers\Api\Admin\V1_0;

use App\Http\Controllers\Controller;
use App\Http\Utils\Miscellaneous;
use App\Http\Utils\MyLog;
use App\Models\Admin\Group;
use App\Models\Picture;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Input;


class GroupController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $query = Group::query();

        $inputs = Input::get();
        foreach ($inputs as $key => $value) {
            if ($key != 'page' && $key != 'pagination_per_page') {
                $query->where('groups.' . $key,$value);
            }
        }

        $query->orderBy('name');

        if (isset($inputs['pagination_per_page']))
            return $query->with('category')->paginate($inputs['pagination_per_page']);
        else if (!isset($inputs['pagination_per_page']) && isset($inputs['page']))
            return $query->with('category')->paginate();
        else if (!isset($inputs['pagination_per_page']) && !isset($inputs['page']))
            return $query->with('category')->get();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $warning = null;
        $group_stored = Group::where('name', $request->name)->first();
        if ($group_stored != null)
            $warning = 'group_already_exists_name';
        if ($warning != null) {
            $status = 409;
            $message = Lang::get('messages.'.$warning);
            MyLog::Warning($status, $warning, $message);
            return response()->json(['error' => $warning, 'message' => $message], $status);
        }

        $inputs = $request->all();
        DB::transaction(function () use ($inputs) {
            $group = new Group;
            foreach ($inputs as $key => $value) {
                if ($key != 'external_references' && $key != 'pictures')
                    $group[$key] = $value;
            }
            $group->save();

            if (isset($inputs["external_references"])) {
                $references = $inputs["external_references"];
                foreach ($references as $reference) {
                    $reference = collect($reference);
                    $group->clients()->attach($reference);
                }
            }

            if (isset($inputs["pictures"])) {
                $pictures = $inputs["pictures"];
                foreach ($pictures as $picture_input) {
                    $picture = new Picture();
                    foreach ($picture_input as $key2 => $value2) {
                        $picture[$key2] = $value2;
                    }
                    $group->pictures()->save($picture);
                }
            }

            Miscellaneous::incrementVersion();
        });
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        $group = Group::findOrFail($id);
        $group->category;
        $group->products;
        $group->pictures;
        $group->clients;

        return $group;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $group = Group::findOrFail($id);
        $warning = null;

        if (Input::has('name'))
            $group->name = Input::get('name');
        $groups_stored = Group::where('name', $group->name);
        $groups_stored_count = $groups_stored->count();
        if ($groups_stored_count == 1) {
            if ($group->id != $groups_stored->first()->id)
                $warning = 'group_already_exists_name';
        }
        else if ($groups_stored_count > 1)
            $warning = 'group_already_exists_name';
        if ($warning != null) {
            $status = 409;
            $message = Lang::get('messages.'.$warning);
            MyLog::Warning($status, $warning, $message);
            return response()->json(['error' => $warning, 'message' => $message], $status);
        }

        $inputs = $request->all();
        DB::transaction(function () use ($group, $inputs) {
            foreach ($inputs as $key => $value) {
                if ($key != 'external_references' && $key != 'pictures')
                    $group->$key = $value;
            }
            $group->save();

            if (isset($inputs["external_references"])) {
                $references = $inputs["external_references"];
                $references_id_name_map = array();
                foreach ($references as $referenceInput) {
                    $client_id = $referenceInput['client_id'];
                    $reference_name = $referenceInput['reference_name'];
                    $references_label_name_map['reference_name'] = $reference_name;
                    $references_id_name_map[$client_id] = $references_label_name_map;
                }
                $group->clients()->sync($references_id_name_map);
            }

            if (isset($inputs["pictures"])) {
                $pictures = $inputs["pictures"];
                $group->pictures()->delete();
                foreach ($pictures as $picture_input) {
                    $picture = new Picture();
                    foreach ($picture_input as $key2 => $value2) {
                        $picture[$key2] = $value2;
                    }
                    $group->pictures()->save($picture);
                }
            }

            Miscellaneous::incrementVersion();
        });
    }
}
