(function( $ ) {
    $.Shop = function( element ) {
        this.$element = $('.single-product-wrap');
        this.init();

    };

    $.Shop.prototype = {
        init: function() {
            // Properties
            this.cartPrefix = "flexoli-"; // Prefix string to be prepended to the cart's name in the session storage
            this.cartName = this.cartPrefix + "cart"; // Cart name in the session storage
            this.shippingRates = this.cartPrefix + "shipping-rates"; // Shipping rates key in the session storage
            this.total = this.cartPrefix + "total"; // Total key in the session storage
            this.storage = localStorage; // shortcut to the localStorage object
            this.$formAddToCart = this.$element.find( "#add_to_cart" ); // Forms for adding items to the cart
            this.$formCart = this.$element.find( "#cart_table" ); 
            
            this.$shoppingCartActions = this.$element.find( "#shopping-cart-actions" ); 
            this.$emptyCartBtn = this.$shoppingCartActions.find( "#empty-cart" ); 
            
            // Object containing patterns for form validation
            this.requiredFields = {
                expression: {
                    value: /^([\w-\.]+)@((?:[\w]+\.)+)([a-z]){2,4}$/
                },
                
                str: {
                    value: ""
                }
                
            };

            // Method invocation
            this.createCart();
            this.handleAddToCartForm();
            this.emptyCart();
            this.displayCart();
            this.addToCarteMenu()
            this.deleteProduct();
            this.sendCommand();

            
        },
        
        // Public methods
        
        // Creates the cart keys in the session storage
        
        createCart: function() {
            if( this.storage.getItem( this.cartName ) == null ) {
            
                var cart = {};
                cart.items = [];
            
                this.storage.setItem( this.cartName, this._toJSONString( cart ) );
                this.storage.setItem( this.shippingRates, "0" );
                this.storage.setItem( this.total, "0" );
            }
        },

        // Delete a product from the shopping cart

        deleteProduct: function() {
            var self = this;
                var cart = this._toJSONObject( this.storage.getItem( this.cartName ) );
                var items = cart.items;
            $( document ).on( "click", ".remove", function( e ) {
                e.preventDefault();
                var product= $(this).data("product").split(',');
                    if(confirm('Souhaitez-vous supprimer l’article'+" "+product[1])){
                        var productid=product[0];
                        var newItems = [];
                    for( var i = 0; i < items.length; ++i ) {
                        var item = items[i];
                        var product = item.id;
                        if( product == productid ) {
                            items.splice( i, 1 );
                        }
                    }
                    newItems = items;
                        var updatedCart = {};
                    updatedCart.items = newItems;
                    var updatedTotal = 0;
                    var totalQty = 0;
                    if( newItems.length == 0 ) {
                        updatedTotal = 0;
                        totalQty = 0;
                    } else {
                        for( var j = 0; j < newItems.length; ++j ) {
                            var prod = newItems[j];
                            var sub = prod.price * prod.qty;
                            updatedTotal += sub;
                            totalQty += prod.qty;
                        }
                    }

                    self.storage.setItem( self.cartName, self._toJSONString( updatedCart ) );
                    $( this ).parents( ".mini-cart-product" ).remove();
                    $('.cart-number').text(items.length);
                    self.displayCart();
                }
            });
            //}
        },

        // Displays the shopping cart
        changeQty: function() {
            var self = this;
            var $preQty = $('#cart_table').find($('.pro-qty'));
                $preQty.prepend('<span class="dec qtybtn" style="margin:auto;"><i class="zmdi zmdi-minus"></i></span>');
                $preQty.append('<span class="inc qtybtn" style="margin:auto;"><i class="zmdi zmdi-plus"></i></span>');
            $preQty.find($('.qtybtn')).on('click', function() {
                var $button = $(this);
                var oldValue = $button.parent().find('input').val();
                if ($button.hasClass('inc')) {
                  var newVal = parseFloat(oldValue) + 1;
                } else {
                   // Don't allow decrementing below zero
                  if (oldValue > 1) {
                    var newVal = parseFloat(oldValue) - 1;
                    } else {
                      newVal = 1;
                  }
                }
                $button.parent().find('input').val(newVal);
                var _price = $button.closest('tr').find($('.cart-price')).text();
                var _rate = $button.closest('tr').find($('.cart-remise')).text();
                var _totalRate = _price - (_price * _rate / 100);
                $button.closest('tr').find($('.cart-total')).text(newVal*_totalRate);

                /* update cart*/
                var cart = self._toJSONObject( self.storage.getItem( self.cartName ) );
                var product= $button.closest('tr').find($("button" )).data( "product" ).split(',');
                var _idProduct           = product[0];
                var _variante             = $button.closest('tr').find($( ".al-img-vt" )).data( "product" );
                var items = cart.items;
                var updatedCart = {};
                    updatedCart.items = [];

                for( var i = 0; i < items.length; ++i ) {
                    var item = items[i];
                    var productId = item.id;
                    var productVariante = item.variante_code;
                    var productVarianteId = item.variante_id; 
                    var nqty = item.qty; 
                    var nlength = item.length;
                    if( productId == _idProduct && productVariante == _variante ) {
                        _inCart = false;
                        nqty = newVal;
                        //nlength = newVal;
                    }
                    var cartObj = {
                        id: item.id,
                        product: item.product,
                        price: item.price,
                        price_unit: item.price_unit,
                        qty: nqty,
                        length : nlength,
                        variante : item.variante,
                        variante_id : item.variante_id,
                        variante_code:item.variante_code,
                        picture : item.picture,
                        discount : item.discount,
                        subtotal : item.subtotal,
                    };

                    updatedCart.items.push( cartObj );
                }
                self.storage.setItem( self.cartName, self._toJSONString( updatedCart ) );
                self.displayCart();
            });
                  $('.pro-qty').on('keyup', function() {
                var $button = $(this);
                var list=$button.context.children;
                var exist=false;
                for (var i = 0; i <list.length; i++) {
                    if(list[i].className=="amt_errqty_panier") exist=true
                }
                if(exist==false){
                    $button.append('<span class="amt_errqty_panier"></span>');
                }
                var data = $button.parent().find('input').val();
                var regx =/^(0|[1-9][0-9]*)$/;
                /* update cart*/
                if (data.match(regx)) {
                    var val = '';
                    if ($button.parent().find('input').val() != '') {
                        val = $button.parent().find('input').val();
                    }
                    var _price = $button.closest('tr').find($('.cart-price')).text();
                    var _rate = $button.closest('tr').find($('.cart-remise')).text();
                    var _totalRate = _price - (_price * _rate / 100);
                    $button.closest('tr').find($('.cart-total')).text(val * _totalRate);
                    /* update cart*/
                    var cart = self._toJSONObject(self.storage.getItem(self.cartName));
                    var product = $button.closest('tr').find($("button")).data("product").split(',');
                    var _idProduct = product[0];
                    var _variante = $button.closest('tr').find($(".al-img-vt")).data("product");
                    var items = cart.items;
                    var updatedCart = {};
                    updatedCart.items = [];

                    for (var i = 0; i < items.length; ++i) {
                        var item = items[i];
                        var productId = item.id;
                        var productVariante = item.variante_code;
                        var productVarianteId = item.variante_id;
                        var nqty = item.qty;
                        var nlength = item.length;
                        if (productId == _idProduct && productVariante == _variante) {
                            _inCart = false;
                            nqty = val;
                            //nlength =val;
                        }

                        var cartObj = {
                            id: item.id,
                            product: item.product,
                            price: item.price,
                            price_unit: item.price_unit,
                            qty: nqty,
                            length: nlength,
                            variante: item.variante,
                            variante_id: item.variante_id,
                            variante_code: item.variante_code,
                            picture: item.picture,
                            discount: item.discount,
                            subtotal: item.subtotal,
                        };
                        updatedCart.items.push(cartObj);
                    }
                    self.storage.setItem(self.cartName, self._toJSONString(updatedCart));
                    self.displayCart();
                }
                else {
                    $('.amt_errqty_panier').text('Quantité invalide !').css({
                        'color': '#fff',
                        'background': '#75B1D8',
                        'padding': '3px'
                    })
                        .fadeIn('slow');

                }

            });
            $('.pro-lgt').on('keyup', function() {
                var regx =/^\d+((\.|\,)\d+)?$/;
                var $button = $(this);
                var list=$button.context.children;
                var exist=false;
                for (var i = 0; i <list.length; i++) {
                    if(list[i].className=="amt_errlgt_panier") exist=true
                }
                if(exist==false){
                    $button.append('<span class="amt_errlgt_panier"></span>');
                }

                var data = $button.parent().find('input').val().replace(',','.');
                var index=$button.parent().find('p').text();
                
                /* update cart*/
                if (data.match(regx)) {
                    var cart = self._toJSONObject( self.storage.getItem( self.cartName ) );
                var _idProduct           = $button.closest('tr').find($("button" )).data( "product" );
                var _variante             = $button.closest('tr').find($( ".cart-variant" )).text();
                var items = cart.items;
                var updatedCart = {};
                updatedCart.items = [];
                for( var i = 0; i < items.length; ++i ) {
                    var item = items[i];
                    var productId = item.id;
                    var productVariante = item.variante;
                    var productVarianteId = item.variante_id;
                    var nlength = item.length;
                    var nqty = item.qty;
                    if (i == index) {
                        _inCart = false;
                    //nqty = $button.parent().find('input').val().replace(',','.');
                    nlength =$button.parent().find('input').val().replace(',','.');
                }
                    var cartObj = {
                        id: item.id,
                        product: item.product,
                        price: item.price,
                        price_unit: item.price_unit,
                        length : nlength,
                        qty:nqty,
                        variante : item.variante,
                        variante_id : item.variante_id,
                        variante_code:item.variante_code,
                        picture : item.picture,
                        discount : item.discount,
                        subtotal : item.subtotal,
                    };
                    updatedCart.items.push( cartObj );
                }
                self.storage.setItem( self.cartName, self._toJSONString( updatedCart ) );
                self.displayCart();
            }
             else {
                    $('.amt_errlgt_panier').text('Longueur invalide !').css({
                        'color': '#fff',
                        'background': '#75B1D8',
                        'padding': '3px'
                    })
                        .fadeIn('slow');

                }

            });
        },
        displayCart: function() {
            var self = this;
            if( this.$formCart ) {
                var cart = this._toJSONObject( this.storage.getItem( this.cartName ) );
                var items = cart.items;
                var $tableCart = $('#cart_table').find('table');
                var $tableCartBody = $tableCart.find( "tbody" );
                var $loader = $('.loading-center'),
                    $ht_total = $('#ht_total'),
                    $tva_total = $('#tva_total'),
                    $ttc_total = $('#ttc_total');
                $.ajax({
                    type: "GET",
                    url: "cart-table.php",
                    data:{ cart_table : JSON.stringify(items) },
                    dataType: 'json',
                    beforeSend: function(){
                    },
                    success: function(data) {
                        $loader.hide();
                        $tableCartBody.html(data.carte);
                        $ht_total.html(data.total_ht)
                        $tva_total.html(data.total_tva)
                        $ttc_total.html(data.total_ttc)
                        self.changeQty();
                        //self.deleteProduct();
                    }
                });
            }
        },
        emptyCart: function() {
            var self = this;
            if( self.$emptyCartBtn.length ) {
                self.$emptyCartBtn.on( "click", function() {
                    self._emptyCart();
                });
            }
        },        
        addToCarteMenu: function() {
            var self = this;
            var cart = this._toJSONObject( this.storage.getItem( this.cartName ) );
            var items = cart.items;
            $.ajax({
                type: "GET",
                url: "cart-list.php",
                data:{ cart_list : JSON.stringify(items) },
                dataType: 'json',
                success: function(data) {
                    $('#cart_list').html(data);
                   //self.deleteProduct();
                }
            });


        },
        handleAddToCartForm: function() {
            var self = this;
            self.$formAddToCart.click(function(event) {
                if($('#lgtbutton').val()){
                $("#modal1").text('Longueur: '+$('#lgtbutton').val()+' Mètre lineaire')}
                if($('#qtybutton').val()){
                    $("#modal1").text('Quantité: '+$('#qtybutton').val())}
                    var _unit=$("#unit" ).data("unit");
                    var _price = self._convertString($("#product_price").text().replace(' ','').replace(',','.'));
                    var _name = $(".single-pro-title").text();
                    var _inCart = true;
                    var _idProduct           = $("#select_product" ).val();
                    var _qty                 = self._convertString($("#qtybutton").val());
                    var _picture             = $(".product-big-image img").attr('src');
                    var _variante            = $( "#product_variante input:checked" ).val();
                    var _varianteId            = $( "#product_variante input:checked" ).attr('data-variante');
                    var _varianteCode           = $( "#product_variante input:checked" ).attr('id');
                    var _discount            = $( "#discount_rate" ).text();
                    var _priceUnit           = self._convertString($("#product_price_unit").text().replace(' ','').replace(',','.'));
                    var _group               =$('#item1 span').text();
                    var _product_name             =$('#item2 h4').text();
                //var qty = self._convertString( $form.find( ".qty" ).val() );
                if(_unit==2) {
                    var _length = self._convertString($("#lgtbutton").val().replace(',','.'));
                    var subTotal = _length * _price;
                    _qty = 1;
                }
                if(_unit==1 || _unit==5) {
                    var subTotal = _qty * _price;

                }
                var total = self._convertString( self.storage.getItem( self.total ) );
                    var sTotal = total + subTotal;

                    /* if already add*/
                    var cart = self._toJSONObject( self.storage.getItem( self.cartName ) );
                    var items = cart.items;
                    var updatedCart = {};
                        updatedCart.items = [];

                    for( var i = 0; i < items.length; ++i ) {
                        var item = items[i];
                        var productId = item.id;
                        var productVariante = item.variante;
                        var nqty = item.qty;
                        var nlength = item.length;
                        if( productId == _idProduct && productVariante == _variante && _unit!=2) {
                            _inCart = false;
                            nqty    = item.qty + _qty;
                            nlength = item.length + _length;
                        }

                        var cartObj = {
                            id: item.id,
                            product: item.product,
                            price: item.price,
                            price_unit: item.price_unit,
                            qty: nqty,
                            length : nlength,
                            variante : item.variante,
                            variante_id : item.variante_id,
                            variante_code:item.variante_code,
                            picture : item.picture,
                            discount : item.discount,
                            subtotal : item.subtotal,
                            group:item.group,
                            product_name:item.product_name
                        };

                        updatedCart.items.push( cartObj );

                    }

                    self.storage.setItem( self.total, sTotal );
                    if (_inCart) {
                        self._addToCart({
                            id: _idProduct,
                            product: _name,
                            price: _price,
                            price_unit: _priceUnit,
                            qty: _qty,
                            length : _length,
                            variante : _variante,
                            variante_id : _varianteId,
                            variante_code :_varianteCode,
                            picture : _picture,
                            discount : _discount,
                            subtotal : subTotal,
                            group : _group,
                            product_name:_product_name
                        });
                    } else {
                        self.storage.setItem( self.cartName, self._toJSONString( updatedCart ) );
                    }

                    self.addToCarteMenu();
                if($('#lgtbutton').val()){
                    $('#lgtbutton').val(1)}
                if($('#qtybutton').val()){
                    $('#qtybutton').val(1)}
                var price = $('#product_price').text();
                $('#product_total').val(price);
            });
        },
        sendCommand: function(){
            var self = this;
            var _checkedAdress =  $('input[name=adressRadios]:checked').val();
            var form_checked = $("."+_checkedAdress+"");
            $("form.delivrey").validate({
               messages: {
                    name: {
                        required: 'Ce champ est requis',
                        email: "Veuillez saisir une adresse e-mail valide."
                    },
                   prenom: {
                       required: 'Ce champ est requis',
                       email: "Veuillez saisir une adresse e-mail valide."
                   },

                    adress: {
                        required: 'Ce champ est requis'
                    },
                    codePostal: {
                        required: 'Ce champ est requis',
                        number:   'Veuillez saisir une code postal correct',
                        minlength: 'le code doit contien 8 chiffre',
                    }  
                },
                rules: {
                    codePostal: {
                        required: {
                            depends: function (element) {
                                return ($('[id="inlineRadio2"]').is(':checked')) ? true : false;
                            }
                        },
                        minlength: 5,
                        number: true
                    },
                    adress: {
                        required: {
                            depends: function (element) {
                                return ($('[id="inlineRadio2"]').is(':checked')) ? true : false;
                            }
                        }
                    },
                    name: {
                        required: {
                            depends: function (element) {
                                return ($('[id="inlineRadio2"]').is(':checked')) ? true : false;
                            }
                        }
                    },
                    prenom: {
                        required: {
                            depends: function (element) {
                                return ($('[id="inlineRadio2"]').is(':checked')) ? true : false;
                            }
                        }
                    }
                },
                submitHandler: function (form) {
                    if ($('[id="inlineRadio1"]').is(':checked')) {
                       var first_name       =  $("input[name='first']").val();
                       var last_name       =  $("input[name='last']").val();
                       var gsm       =  $("input[name='gsm1']").val();
                       var adress     =  $("textarea[name='adress1']").val();
                       //var codePostal =  $("input[name='codePostal1']").val();
                       var adress_followup=$("input[name='adress_followup1']").val();
                       var town       =  $("input[name='ville']").val();
                    } else {
                       /* var name       =  form_checked.find($("input[name='name']")).val();
                        var adress     =  form_checked.find($("textarea[name='adress']")).val();
                        var codePostal =  form_checked.find($("input[name='codePostal']")).val();
                        var town       =  form_checked.find($("#town option:selected")).text();*/
                        var first_name       =  $("input[name='prenom']").val();
                       var last_name       =  $("input[name='name']").val();
                       var gsm       =  $("input[name='gsm']").val();
                        var adress     =  $("textarea[name='adress']").val();
                        var adress_followup =  $("input[name='adress_followup']").val();
                        var town       =  $("select[name='town']").val();

                   }
                    var url        =  $('form.delivrey').attr('data-action');
                    var token        =  $('form.delivrey').attr('data-token');
                    var cart = self._toJSONObject( self.storage.getItem( self.cartName ) );
                    var items = cart.items;
                    var lines = [];
                    for( var i = 0; i < items.length; ++i ) {
                        var item = items[i];
                        lines.push({
                          product_id            : item.id,
                          variant_id            : item.variante_id,
                            variant_ERP_code    : item.variant_ERP_code,
                          quantity              : item.qty,
                          length                : item.length,
                          total_ttc             : item.qty * item.price,
                          product_name          : item.product,
                          product_ERP_code      : "Code produit",
                          product_price_ttc     : item.price,
                        });
                    }
                    var delivery = {
                       // contact_name      : name,
                        first_name:first_name,
                        last_name:last_name,
                        phone:gsm,
                        adress            : adress,
                        //zip_code          : codePostal,
                        adress_followup:   adress_followup,
                        town              : town
                    };
                    console.log("delivery",delivery)
                    $.ajax({
                        url : url,
                        type: 'POST',
                        data: {   "total_ht"  :"24524" ,
                                  "total_vat": "54242",
                                  "total_ttc": "452452",
                                  "delivery" : delivery,
                                  "items"    : lines}, 
                        headers: {
                              "Content-Type": "application/json",
                              "Authorization" : token,
                              "Content-Type": "application/x-www-form-urlencoded"
                        },
                        contentType: "application/json; charset=utf-8",    
                        success: function (data) {
                            $oid = data.command_number;
                            $orgAmount=data.ttc_total;
                            self._emptyCart();
                            window.location.replace('/1.PaymentRequest.php?command_number='+ $oid +'& ttc_total='+ $orgAmount.replace(',','.').replace(' ','') +'& first_name='+ delivery.first_name+'& last_name='+ delivery.last_name+'& phone='+ delivery.phone+'& adress='+ delivery.adress+'& adress_followup='+ delivery.adress_followup+'& town='+ delivery.town+'');
                            
                        },
                        error: function(xhr, status, error) {
                           
                        }
                    });
                   return false;
                } 
            }); 

        },
        _emptyCart: function() {
            this.storage.clear();
        },
        _formatNumber: function( num, places ) {
            var n = num.toFixed( places );
            return n;
        },        
        _convertString: function( numStr ) {
            var num;
            if( /^[-+]?[0-9]+\.[0-9]+$/.test( numStr ) ) {
                num = parseFloat( numStr );
            } else if( /^\d+$/.test( numStr ) ) {
                num = parseInt( numStr, 10 );
            } else {
                num = Number( numStr );
            }
            
            if( !isNaN( num ) ) {
                return num;
            } else {
                console.warn( numStr + " cannot be converted into a number" );
                return false;
            }
        },
        _convertNumber: function( n ) {
            var str = n.toString();
            return str;
        },
        _toJSONObject: function( str ) {
            var obj = JSON.parse( str );
            return obj;
        },
        _toJSONString: function( obj ) {
            var str = JSON.stringify( obj );
            return str;
        },
        _addToCart: function( values ) {
            var cart = this.storage.getItem( this.cartName );
            
            var cartObject = this._toJSONObject( cart );
            var cartCopy = cartObject;
            var items = cartCopy.items;
            items.push( values );
            
            this.storage.setItem( this.cartName, this._toJSONString( cartCopy ) );
        },

 
    };
    $('#inlineRadio2').click(function() {
        $('#name_delivery').prop("disabled", false);
        $('#prenom_delivery').prop("disabled", false);
        $('#gsm_delivery').prop("disabled", false);
        $('#adresse_delivery').prop("disabled", false);
        $('#adress_followup_delivery').prop("disabled", false);
        $('#town_delivery').prop("disabled", false);
    })
    $('#inlineRadio1').click(function() {
        $('#name_delivery').prop("disabled", true);
        $('#prenom_delivery').prop("disabled", true);
        $('#gsm_delivery').prop("disabled", true);
        $('#adresse_delivery').prop("disabled", true);
        $('#adress_followup_delivery').prop("disabled", true);
        $('#town_delivery').prop("disabled", true);
    })
        $('#num').click(function() {
        if ($('#num').prop('checked')==true)
            $('#numCommande').val("");
    })
    $('#inlineCheckbox02').click(function() {
        if ($('#inlineCheckbox02').prop('checked')==true) {
            $('#start').val("")
            $('#end').val("")
        }
    })
    $('#inlineCheckbox03').click(function() {
        if ($('#inlineCheckbox03').prop('checked')==true)
            $('#status').val("");
    })
      $('#start').on('change', function() {
        document.getElementById("end").setAttribute("min", $('#start').val())
    })
    $('#end').on('change', function() {
        document.getElementById("start").setAttribute("max", $('#end').val())
    })
    $(function() {
        var shop = new $.Shop( "#site" );
    });

})( jQuery );