$(function () {
    "use strict";
    jQuery.support.cors = true;
    getProduct()
    calculTotal()
    validateForm()
    userLogOut()
    commandFilter()
})
jQuery.validator.addMethod("accept", function(value, element, param) {
    return value.match(new RegExp("." + param + "$"));
});
function userLogOut(){
    $("#user_logout[href]").on('click', function(){
        removeCookieUser('flexolitokenSession');
        self._emptyCart();
        window.location = this.href;
    })
}

function getProduct() {
    $('.product-title').text($('#product-title').attr('data-name'));
    $('#select_product').on('change', function() {
    var _ID   =  this.value ;
        $.ajax({
            url: 'product-details.php',
            type: 'GET',
            data: { 'id': _ID }, 
            contentType: "application/json; charset=utf-8",           
            success: function (data) {
                $('.product-details').html(data);
                $('#qtybutton').val(1);
                $('.product-title').text($('#product-title').attr('data-name'));
                calculTotal()
            },
            error: function (x, y, z) {
                console.log(x + '\n' + y + '\n' + z);
            }
        });
    })
}

$('#searchComm').on('click', function() {
    var token=$('#token2').text();
    var number= $('#numCommande').val();
    var status= $('#status').val();
    var start=$('#start').val();
    var end=$('#end').val();
    var parms = {
        number : number,
        status : status,
        start : start,
        end:end
    };
    console.log('parms',parms)
    $.ajax({
        url:'http://backend.flexoli.com/public/api/users/individuals/v1_0/commands',
        type: 'GET',
        data:parms,
        headers: {
            "Content-Type": "application/x-www-form-urlencoded",
            "Authorization" : token
        },
        success: function (data) {
            $('#resultsearch').empty();
            $('#resultsearch').append('<thead class="thead-inverse"> <tr>  <th>Numéro commande</th> <th>Date commande</th> <th>Status</th><th></th> </tr> </thead>');
            data.forEach(function(commmand) {
                $('#resultsearch').append('<tbody> <tr> <td><span class="visible-xs small-text">Numéro commande</span>'+commmand.number+'<td><span class="visible-xs small-text">Date commande</span>'+formatDate(commmand.created_at)+'</td> <td><span class="visible-xs small-text">Status</span>'+commmand.status.name+'</td> <td> <li class="btn btn-flexo btn-sm"><a href="consultation.php?id='+commmand.id+'">Consulter </a></li></td> </tr> </tbody>');
            });
        },
        error: function(xhr, status, error) {
            var err =  eval( "(" + xhr.responseText+ ")"  );
            if (err.message !== '') {
                var message = "Une erreur s'est produite, merci de réessayer.";
                $('.error').html(message);
            }

        }
    });


});
function calculTotal() {
    var price = $('#product_price').text();
    $('#product_total').val(price);
    $("#product_variante input:radio:first").attr('checked', true);

    $('#flxrule').click(function() {
        if($('#flxrule').is(':checked')){
            if($('#token1').text().includes('Bearer')) {
                $(".checkout-link").removeClass('no-active');
                $(".checkout-link").attr('href','delivery.php');
            }
            else {
                $(".checkout-link").removeClass('no-active');
                $(".checkout-link").attr('href','signup.php');
            }
        } else {
            $(".checkout-link").addClass('no-active');
        }
    })
    $('#waitMe_ex').click(function(){
        console.log('heeeeeeere')
        run_waitMe($('.containerBlock > form'), 1,"none");
    });

} 

function checkAccess(token) {
    var error = $('.error');
    error.html('');
    $.ajax({
        url:'http://backend.flexoli.com/public/api/users/individuals/v1_0/checkAccess',
        type: 'GET',
        headers: {
            "Content-Type": "application/x-www-form-urlencoded",
            "Authorization" : token
        },
        success: function (data, textStatus, xhr) {
            if (xhr.status == 200) {
                this.cartPrefix = "flexoli-"; // Prefix string to be prepended to the cart's name in the session storage
                this.cartName = this.cartPrefix + "cart"; // Cart name in the session storage
                this.storage = localStorage;
                var self = this;
                var cart = JSON.parse( this.storage.getItem( this.cartName ) );
                var items = cart.items;
                setCookie('flexolitokenSession', token)
                if(items.length==0)
                window.location.replace('/flexoli');
                else window.location.replace('cart.php');

            } else {
                var message = "Les informations d'identification de l'utilisateur sont incorrectes.";
                $('.error').html(message);
            }
        },
        error: function (x, y, z) {
            console.log(x + '\n' + y + '\n' + z);
        }
    });
}
function validateForm() {

    $("form.change-password-form").validate({
        messages: {
            password: {
                required: 'Ce champ est requis'
            },
            pwd1: {
                required: 'Ce champ est requis'
            },
            pwd2: {
                required: 'Ce champ est requis',
                equalTo: 'Mots de passes ne sont pas identiques.'
            }
        },
        rules: {
            password: "required",
            pwd1: "required",
            pwd2: {
              equalTo: "#pwd1"
            }
        },
        submitHandler: function (form) {
            var token      =  $('form.change-password-form').attr('data-token');
            var old_password =  $("input[name='password']").val();
            var new_password =$("input[name='pwd1']").val();
            var confirm_new_password=$("input[name='pwd2']").val();
            $.ajax({
                url:'http://backend.flexoli.com/public/api/users/individuals/v1_0/password',
                type: 'PUT',
                data:  {
                    "old_password":old_password,
                    "new_password":new_password,
                    "confirm_password":confirm_new_password
                } ,
                headers: {
                    "Content-Type": "application/x-www-form-urlencoded",
                    "Authorization" : token
                },
                success: function (data) {
                    window.location.replace('confirmUpdatePassword.php');
                },
                error: function(xhr, status, error) {
                    var err =  eval( "(" + xhr.responseText+ ")"  );
                    if (err.message !== '') {
                        var message = "Une erreur s'est produite, merci de réessayer.";
                        $('.error').html(message);
                    }

                }
            });
            return false;
        }
    });
    $("form.enregister-form").validate({
        messages: {
            email: {
                required: 'Ce champ est requis',
                email: "e-mail non valide."
            },
            nameInfos: {
                required: 'Ce champ est requis',
                accept:  'nom non valide',
                minlength: 'Nom trop court',
                maxlength: 'Nom trop long'
            },
            firstnameInfos: {
                required: 'Ce champ est requis',
                accept:  'nom non valide',
                minlength: 'Prénom trop court',
                maxlength: 'Prénom trop long'
            },
            passeword: {
                required: 'Ce champ est requis',
                minlength: 'password trop court',
                maxlength: 'password trop long'
            },
            passewordConfirmation: {
                required: 'Ce champ est requis',
                minlength: 'password trop court',
                maxlength: 'password trop long',
                equalTo: 'Mots de passes ne sont pas identiques.'

            },
            gsmInfos: {
                required: 'Ce champ est requis',
                number: "Gsm non valide.",
                minlength:"Gsm doit contenir 10 chiffres.",
                maxlength:"Gsm doit contenir 10 chiffres."

            },
            landInfos: {
                number: "Fixe non valide.",
                minlength:"Fixe doit contenir 10 chiffres.",
                maxlength:"Fixe doit contenir 10 chiffres."
            },
            postalInfos: {
                number: "Code postal non valide."
            },
            adressInfos: {
                required: 'Ce champ est requis',
                minlength: 'adresse trop court',
                maxlength: 'adresse trop long',
            },
            cityInfos: {
                required: 'Ce champ est requis',
                cityInfos: "ville non valide."
            },
            captcha_register: {
                required: 'Ce champ est requis'
            }
        },
        rules: {
            email: {
                required: true
            },
            captcha_register: {
                required: true
            },
            nameInfos: {
                required: true,
                minlength: 3,
                maxlength: 20,
                accept: "[a-zA-Z]+"

            },
            firstnameInfos: {
                required: true,
                minlength: 3,
                maxlength: 20,
                accept: "[a-zA-Z]+"
            },
            passeword: {
                required: true,
                minlength: 6,
                maxlength: 14
            },
            passewordConfirmation: {
                required: true,
                equalTo: "#passeword",
                minlength: 6,
                maxlength: 14,
            },
            gsmInfos: {
                required: true,
                number:true,
                minlength: 10,
                maxlength: 10
            },
            landInfos: {
                number:true,
                minlength: 10,
                maxlength: 10
            },

            cityInfos: {
                required: true
            },
            postalInfos: {
            number:true
            },
            adressInfos: {
                required: true,
                minlength: 3,
                maxlength: 200
            }

        },
        submitHandler: function (form) {
            var email =  $("input[name='email']").val();
            var last_name =  $("input[name='nameInfos']").val();
            var first_name =  $("input[name='firstnameInfos']").val();
            var password =  $("input[name='passeword']").val();
            var mobile =  $("input[name='gsmInfos']").val();
            var landphone =  $("input[name='landInfos']").val();
            var town =  $("[name='cityInfos']").val();
            var zip_code =  $("input[name='postalInfos']").val();
            var adress =  $("input[name='adressInfos']").val();
            var civility_id=$("select[name='civil']").val();
            var captcha = $("input[name='captcha_register']").val();
            var dataString = 'captcha=' + captcha;

            $.ajax({
                type: "POST",
                url: "verify.php",
                data: dataString,
                success: function(html) {
                    console.log('html',html)
                    if(html=="true") {
                        console.log('town',town)
                        $.ajax({
                            url: 'http://backend.flexoli.com/public/api/users/individuals/v1_0/register',
                            type: 'POST',
                            data: {
                                "email": email,
                                "last_name": last_name,
                                "first_name": first_name,
                                "password": password,
                                "mobile": mobile,
                                "landphone": landphone,
                                "town": town,
                                "zip_code": zip_code,
                                "adress": adress,
                                "civility_id": civility_id,
                            },
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded"
                            },
                            success: function (data) {
                                window.location.replace('confirmation-register.php');
                            },
                            error: function (xhr, status, error) {
                                var err = eval("(" + xhr.responseText + ")");
                                if (err.message !== '') {
                                    var message = "Une erreur s'est produite, merci de réessayer.";
                                    $('.error').html(message);
                                }

                            }
                        });
                    }
                    else  alert(html);
                    }
                });

            return false;
        }
    });
    $("form.update-form").validate({

        messages: {
            email: {
                required: 'Ce champ est requis',
                email: "e-mail non valide."
            },
            nameInfos: {
                required: 'Ce champ est requis',
                accept:  'nom non valide',
                minlength: 'Nom trop court',
                maxlength: 'Nom trop long'
            },
            firstnameInfos: {
                required: 'Ce champ est requis',
                accept:  'nom non valide',
                minlength: 'Prénom trop court',
                maxlength: 'Prénom trop long'
            },
            passeword: {
                required: 'Ce champ est requis',
                minlength: 'password trop court',
                maxlength: 'password trop long'
            },
            passewordConfirmation: {
                required: 'Ce champ est requis',
                minlength: 'password trop court',
                maxlength: 'password trop long',
                equalTo: 'Mots de passes ne sont pas identiques.'

            },
            gsmInfos: {
                required: 'Ce champ est requis',
                number: "Gsm non valide.",
                minlength:"Gsm doit contenir 10 chiffres.",
                maxlength:"Gsm doit contenir 10 chiffres."

            },
            landInfos: {
                number: "Fixe non valide.",
                minlength:"Fixe doit contenir 10 chiffres.",
                maxlength:"Fixe doit contenir 10 chiffres."
            },
            postalInfos: {
                number: "Code postal non valide."
            },
            adressInfos: {
                required: 'Ce champ est requis',
                minlength: 'adresse trop court',
                maxlength: 'adresse trop long',
            },
            cityInfos: {
                required: 'Ce champ est requis',
                cityInfos: "ville non valide."
            }
        },
        rules: {
            email: {
                required: true
            },
            nameInfos: {
                required: true,
                minlength: 3,
                maxlength: 20,
                accept: "[a-zA-Z]+"

            },
            firstnameInfos: {
                required: true,
                minlength: 3,
                maxlength: 20,
                accept: "[a-zA-Z]+"
            },
            passeword: {
                required: true,
                minlength: 6,
                maxlength: 14
            },
            passewordConfirmation: {
                required: true,
                equalTo: "#passeword",
                minlength: 6,
                maxlength: 14,
            },
            gsmInfos: {
                required: true,
                number:true,
                minlength: 10,
                maxlength: 10
            },
            landInfos: {
                number:true,
                minlength: 10,
                maxlength: 10
            },

            cityInfos: {
                required: true
            },
            postalInfos: {
                number:true
            },
            adressInfos: {
                required: true,
                minlength: 3,
                maxlength: 200
            }

        },
        submitHandler: function (form) {
            var email =  $("input[name='email']").val();
            var last_name =  $("input[name='nameInfos']").val();
            var first_name =  $("input[name='firstnameInfos']").val();
            var mobile =  $("input[name='gsmInfos']").val();
            var landphone =  $("input[name='landInfos']").val();
            var town =  $("select[name='town_profil']").val();
            var zip_code =  $("input[name='postalInfos']").val();
            var adress =  $("input[name='adressInfos']").val();
            var civility_id=$("select[name='civil']").val();
            var token      =  $('form.update-form').attr('data-token');
            console.log("town",town)
            $.ajax({
                url:'http://backend.flexoli.com/public/api/users/individuals/v1_0/profile',
                type: 'PUT',
                data:  {
                    "last_name":last_name,
                    "first_name":first_name,
                    "mobile":mobile,
                    "landphone":landphone,
                    "town":town,
                    "zip_code":zip_code,
                    "adress":adress,
                    "civility_id":civility_id,
                } ,
                headers: {
                    "Content-Type": "application/x-www-form-urlencoded",
                    "Authorization" : token
                },
                success: function (data) {
                    window.location.replace('confirmUpdateUser.php');
                },
                error: function(xhr, status, error) {
                    var err =  eval( "(" + xhr.responseText+ ")"  );
                    if (err.message !== '') {
                        var message = "Une erreur s'est produite, merci de réessayer.";
                        $('.error').html(message);
                    }

                }
            });
            return false;
        }
    });
    $("form.register-form").validate({
        messages: {
            email: {
                required: 'Ce champ est requis',
                email: "e-mail non valide."
            } 
        },
        rules: {
            email: {
                required: true
            }
        },
         submitHandler: function (form) {
             var email =  $("input[name='email']").val();
             $.ajax({
                 url:'http://backend.flexoli.com/public/api/users/individuals/v1_0/resetPassword',
                 type: 'PUT',
                 data:  {
                     "email":email
                 } ,
                 headers: {
                     "Content-Type": "application/x-www-form-urlencoded"
                 },
                 success: function (data) {
                     window.location.replace('confirmationPassword.php');

                 },
                 error: function(xhr, status, error) {
                     var err =  eval( "(" + xhr.responseText+ ")"  );
                     if (err.message !== '') {
                         var message = "Les informations d'identification de l'utilisateur sont incorrectes.";
                         $('.error').html(message);
                     }

                 }
             });
             return false;
        }
    });

    $("form.connecte").validate({
       messages: {
            emailname: {
                required: 'Ce champ est requis',
                email: "Veuillez saisir une adresse e-mail valide."
            },
            password: {
                required: 'Ce champ est requis'
            },
           captcha: {
               required: 'Ce champ est requis'
           }
        },
        submitHandler: function (form) { 
            var email =  $("input[name='emailname']").val();
            var password =  $("input[name='password']").val();
            var captcha = $("input[name='captcha']").val();
            var dataString = 'captcha=' + captcha;
            $.ajax({
                type: "POST",
                url: "verify.php",
                data: dataString,
                success: function(html) {
                    if(html=="true") {
                        $.ajax({
                            url: 'http://backend.flexoli.com/public/oauth/token',
                            type: 'POST',
                            data: {
                                "grant_type": "password",
                                "client_id": "2",
                                "client_secret": "mVTLXmHp9d3FBDzElhnyYwPYKlu3cGxJu8f8yH5L",
                                "username": email,
                                "password": password
                            },
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded"
                            },
                            contentType: "application/json; charset=utf-8",
                            success: function (data) {
                                var tokenResponse = data.token_type + ' ' + data.access_token;
                                checkAccess(tokenResponse)
                            },
                            error: function (xhr, status, error) {
                                var err = eval("(" + xhr.responseText + ")");
                                if (err.message !== '') {
                                    var message = "Les informations d'identification de l'utilisateur sont incorrectes.";
                                    $('.error').html(message);
                                }

                            }
                        });
                    }
                    else alert(html);
                }
            });

            return false;
        }
    });
    $("form.reset-pass").validate({
        messages: {
            email: {
                required: 'Ce champ est requis',
                email: "Veuillez saisir une adresse e-mail valide."
            }
        },
        submitHandler: function (form) {
            var email =  $("input[name='email']").val();
            $.ajax({
                url:'http://backend.flexoli.com/public/api/users/individuals/v1_0/resetPassword',
                type: 'PUT',
                data:  {
                    "email":email
                   } ,
                headers: {
                    "Content-Type": "application/x-www-form-urlencoded"
                },
                success: function (data) {
                    window.location.replace('/');
                },
                error: function(xhr, status, error) {
                    var err =  eval( "(" + xhr.responseText+ ")"  );
                    if (err.message !== '') {
                        var message = "Les informations d'identification de l'utilisateur sont incorrectes.";
                        $('.error').html(message);
                    }

                }
            });
            return false;
        }
    });
}



function setCookie(name, value){
    var today = new Date();
    var expiry = new Date(today.getTime() + 30 * 24 * 3600 * 1000);
    //document.cookie=name + "=" + escape(value) + "; path=/; expires=" + expiry.toGMTString();
    document.cookie=name + "=" + escape(value) + "; path=/";
}

function getCookie(name){
    return document.cookie;
}

function storeValues(form){
    setCookie("flexolitokenSession", form.submit.value);
    return true;
}

function removeCookieUser(name){
    $.cookie(name, null, { path: '/' });
    return true;
}
function commandFilter(){
    $("input[type=checkbox]").change(function() {
        $('input[type=checkbox]').each(function () {
            if(this.checked) {
                $(this).closest('div').find($('.form-group')).hide()
            }else{
                $(this).closest('div').find($('.form-group')).show()
            }
        });
    });
}
function formatDate(dt){
    var formattedDate = '';
    var d=dt.split('-');
    var t=d[2].split(' ');
    formattedDate=d[0]+"-"+d[1]+"-"+t[0];
    return formattedDate;
}
function simpleDate(dateFilter){
    var formattedDate = '';
    return function(dt) {
        formattedDate = dateFilter(new Date(dt), 'yyyy-M-d');
        return formattedDate;
    }
}