<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Admin
Route::group(['prefix' => 'admin/v1_0', 'as' => 'api.admin.v1_0.', 'middleware' => ['auth:api', 'admin', 'cors']], function () {
    Route::group(['namespace' => 'Api\Admin\V1_0'], function () {
        Route::get('checkAccess', 'AccessController@check');
        Route::resource('categories', 'CategoryController',
            ['only' => ['index', 'show', 'store', 'update']]);
        Route::resource('groups', 'GroupController',
            ['only' => ['index', 'show', 'store', 'update']]);
        Route::resource('products', 'ProductController',
            ['only' => ['index', 'show', 'store', 'update']]);
        Route::resource('variants', 'VariantController',
            ['only' => ['index', 'show', 'store', 'update']]);
        Route::resource('clients', 'ClientController',
            ['only' => ['index']]);
        Route::resource('discounts', 'DiscountController',
            ['only' => ['index', 'show', 'store', 'update']]);
        Route::resource('individuals', 'IndividualController',
            ['only' => ['index', 'show', 'update']]);
        Route::resource('resellerCompanies', 'ResellerCompanyController',
            ['only' => ['index', 'show', 'store', 'update']]);
        Route::resource('resellers', 'ResellerController',
            ['only' => ['index', 'show', 'store', 'update', 'destroy']]);
        Route::resource('commands', 'CommandController',
            ['only' => ['index', 'show']]);
        Route::resource('resellerCommunications', 'ResellerCommunicationController',
            ['only' => ['index', 'show', 'store', 'update']]);
        Route::resource('externalReferencesMissings', 'ExternalReferencesMissingController',
            ['only' => ['index']]);
        Route::resource('channels', 'ChannelController',
            ['only' => ['index']]);
        Route::resource('units', 'UnitController',
            ['only' => ['index']]);
        Route::resource('vats', 'VatController',
            ['only' => ['index']]);
        Route::resource('dimensions', 'DimensionController',
            ['only' => ['index']]);
        Route::resource('commandTypes', 'CommandTypeController',
            ['only' => ['index']]);
    });
    Route::group(['namespace' => 'Api\V1_0'], function () {
        Route::resource('civilities', 'CivilityController',
            ['only' => ['index']]);
        Route::resource('statuses', 'StatusController',
            ['only' => ['index']]);
        Route::put('password', 'AuthenticationController@update');
    });
});

// ERP
Route::group(['prefix' => 'erp/v1_0', 'as' => 'api.erp.v1_0.', 'middleware' => ['auth:api', 'ERP', 'cors']], function () {
    Route::group(['namespace' => 'Api\ERP\V1_0'], function () {
        Route::get('checkAccess', 'AccessController@check');
        Route::resource('commands', 'CommandController',
            ['only' => ['index', 'show']]);
        Route::put('commands', 'CommandController@update');
    });
});

// Individuals Users
Route::group(['prefix' => 'users/individuals/v1_0', 'as' => 'api.users.individuals.v1_0.'], function () {
    // Without token
    Route::group(['middleware' => 'cors'], function () {
        Route::group(['namespace' => 'Api\Users\Individuals\V1_0'], function () {
            Route::resource('catalog', 'CatalogController',
                ['only' => ['index']]);
            Route::get('catalogVersion', 'CatalogController@version');
            Route::resource('categories', 'CategoryController',
                ['only' => ['index', 'show']]);
            Route::resource('groups', 'GroupController',
                ['only' => ['index', 'show']]);
            Route::resource('products', 'ProductController',
                ['only' => ['index', 'show']]);
            Route::resource('offers', 'OfferController',
                ['only' => ['index']]);
            Route::get('cart', 'CartController@calculate');
            Route::resource('register', 'IndividualController',
                ['only' => ['store']]);
            Route::get('search/{key}', 'GroupController@search');
            Route::resource('towns', 'TownController',
                ['only' => ['index', 'show']]);
            Route::put('command_mail/{number}', 'CommandController@send_mail');
        });
        Route::group(['namespace' => 'Api\V1_0'], function () {
            Route::resource('civilities', 'CivilityController',
                ['only' => ['index']]);
            Route::resource('types', 'TypeController',
                ['only' => ['index']]);
            Route::put('resetPassword', 'AuthenticationController@resetPassword');
        });
        Route::group(['namespace' => 'Api\Users\V1_0'], function () {
            Route::resource('welcomePictures', 'WelcomePictureController',
                ['only' => ['index']]);
        });
    });
    // With token
    Route::group(['middleware' => ['auth:api', 'individual', 'isVerified', 'cors']], function () {
        Route::group(['namespace' => 'Api\Users\Individuals\V1_0'], function () {
            Route::get('checkAccess', 'AccessController@check');
            Route::resource('deliveryTowns', 'DeliveryTownController',
                ['only' => ['index', 'show']]);
            Route::get('profile', 'IndividualController@show');
            Route::put('profile', 'IndividualController@update');
            Route::resource('commands', 'CommandController',
                ['only' => ['index', 'show', 'store']]);
            //Route::put('payment/{number}', 'CommandController@update_status');
        });
        Route::group(['namespace' => 'Api\V1_0'], function () {
            Route::resource('statuses', 'StatusController',
                ['only' => ['index']]);
            Route::put('password', 'AuthenticationController@update');
        });
    });
});
Route::get('email-verification/error', 'Auth\RegisterController@getVerificationError')->name('email-verification.error');
Route::get('email-verification/check/{token}', 'Auth\RegisterController@getVerification')->name('email-verification.check');

// Resellers Users
Route::group(['prefix' => 'users/resellers/v1_0', 'as' => 'api.users.resellers.v1_0.'], function () {
    // Without token
    Route::group(['middleware' => 'cors'], function () {
        Route::group(['namespace' => 'Api\V1_0'], function () {
            Route::put('resetPassword', 'AuthenticationController@resetPassword');
        });
    });
    // With token
    Route::group(['middleware' => ['auth:api', 'reseller', 'isVerified', 'cors']], function () {
        Route::group(['namespace' => 'Api\Users\Resellers\V1_0'], function () {
            Route::get('allData/{version}', 'DataController@allData');
            Route::get('checkAccess', 'AccessController@check');
            Route::resource('catalog', 'CatalogController',
                ['only' => ['index']]);
            Route::get('allCatalogs', 'CatalogController@allCatalogs');
            Route::get('standardCatalog', 'CatalogController@standardProductsCategories');
            Route::get('nonStandardCatalog', 'CatalogController@nonStandardProductsCategories');
            Route::get('specificCatalog', 'CatalogController@specificProductsCategories');
            Route::get('favouriteCatalog', 'CatalogController@favouriteProductsCategories');
            Route::get('catalogVersion', 'CatalogController@version');
            Route::resource('categories', 'CategoryController',
                ['only' => ['index', 'show']]);
            Route::resource('groups', 'GroupController',
                ['only' => ['index', 'show']]);
            Route::resource('products', 'ProductController',
                ['only' => ['index', 'show']]);
            Route::resource('offers', 'OfferController',
                ['only' => ['index']]);
            Route::get('search/{key}', 'GroupController@search');
            Route::get('specifics', 'GroupController@specific');
            Route::get('cart', 'CartController@calculate');
            Route::get('profile', 'ResellerController@show');
            Route::resource('commands', 'CommandController',
                ['only' => ['index', 'show', 'store']]);
            Route::resource('favourites', 'FavouriteController',
                ['only' => ['index', 'show', 'store', 'destroy']]);
        });
        Route::group(['namespace' => 'Api\V1_0'], function () {
            Route::resource('civilities', 'CivilityController',
                ['only' => ['index']]);
            Route::resource('statuses', 'StatusController',
                ['only' => ['index']]);
            Route::put('password', 'AuthenticationController@update');
        });
        Route::group(['namespace' => 'Api\Users\V1_0'], function () {
            Route::resource('welcomePictures', 'WelcomePictureController',
                ['only' => ['index']]);
        });
    });
});

// For debug purpose only
/*
Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:api');
*/


//// TODO: to remove once the FrontEnd and BackEnd are migrated to the new routes system ////
// Common
Route::group(['prefix' => 'v1_0', 'as' => 'api.v1_0.', 'namespace' => 'Api\V1_0', 'middleware' => 'cors'], function () {
    Route::resource('civilities', 'CivilityController',
        ['only' => ['index']]);
    Route::resource('statuses', 'StatusController',
        ['only' => ['index']]);
});

//// TODO: to remove once the FrontEnd and BackEnd are migrated to the new routes system ////
// Common for all Users
Route::group(['prefix' => 'users/v1_0', 'as' => 'api.users.v1_0.', 'namespace' => 'Api\V1_0', 'middleware' => ['auth:api', 'user', 'isVerified', 'cors']], function () {
    Route::put('password', 'AuthenticationController@update');
});
Route::group(['prefix' => 'users/v1_0', 'as' => 'api.users.v1_0.', 'namespace' => 'Api\V1_0', 'middleware' => ['cors']], function () {
    Route::put('resetPassword', 'AuthenticationController@resetPassword');
});
