<?php

namespace App\Models\Users;

use Illuminate\Database\Eloquent\Model;

class Individual extends Model
{
    //
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = ['id', 'created_at', 'updated_at', 'deactivated', 'confirmed', 'user_id', 'client_id', 'civility_id', 'town_id'];

    /**
     * Get the user that this individual belongs to.
     */
    public function user()
    {
        return $this->belongsTo('App\User');
    }

    /**
     * Get the Client that this individual belongs to.
     */
    public function client()
    {
        return $this->belongsTo('App\Models\Users\Client');
    }

    /**
     * Get the civilitiy that this individual belongs to.
     */
    public function civility()
    {
        return $this->belongsTo('App\Models\Civility');
    }

    /**
     * Get the Town that this individual belongs to.
     */
    public function town()
    {
        return $this->belongsTo('App\Models\Town');
    }
}
