<?php

namespace App\Models\Admin;

use DB;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    //
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = ['created_at', 'updated_at'];

    /**
     * The list of products.
     */
    public static function products()
    {
        return Product::leftJoin('discounts', 'products.discount_id', '=', 'discounts.id')
            ->leftJoin('client_discount', 'discounts.id', '=', 'client_discount.discount_id')
            ->leftJoin('clients', 'clients.id', '=', 'client_discount.client_id')
            ->select('products.*', 'discounts.ERP_group_code as discount_ERP_group_code', 'clients.ERP_code as discount_client', 'client_discount.rate as discount_rate');
    }

    /**
     * Get the Type Unit that owns the Product.
     */
    public function unit()
    {
        return $this->belongsTo('App\Models\Admin\Unit');
    }

    /**
     * Get the Type Type that owns the Product.
     */
    public function type()
    {
        return $this->belongsTo('App\Models\Type');
    }

    /**
     * Get the Type Vat that owns the Product.
     */
    public function vat()
    {
        return $this->belongsTo('App\Models\Admin\Vat');
    }

    /**
     * Get the Product Group that product belongs to.
     */
    public function group()
    {
        return $this->belongsTo('App\Models\Admin\Group');
    }

    /**
     * The Client that that this
     */
    public function specific()
    {
        return $this->belongsTo('App\Models\Admin\Client', 'specific_client_id')->where('deactivated', 0);
    }

    /**
     * The Discount Group that is related to the product.
     */
    public function discount()
    {
        return $this->belongsTo('App\Models\Admin\Discount')->where('deactivated', 0);
    }

    /**
     * The Variants associated to this product.
     */
    public function variants()
    {
        return $this->belongsToMany('App\Models\Admin\Variant')->where('deactivated', 0);
    }

    /**
     * The external references of this product.
     */
    public function externalReferences()
    {
        return $this->belongsToMany('App\Models\Admin\Client')->where('deactivated', 0)->withPivot('reference_name');
    }

}
