<?php

namespace App\Models\Admin;

use Illuminate\Database\Eloquent\Model;

class Group extends Model
{
    //
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = ['created_at', 'updated_at'];

    /**
     * Get the category that the group belongs to.
     */
    public function category()
    {
        return $this->belongsTo('App\Models\Admin\Category');
    }

    /**
     * Get the products that belongs to this group.
     */
    public function products()
    {
        return $this->hasMany('App\Models\Admin\Product')->where('deactivated', 0);
    }

    /**
     * The Pictures associated to this Group.
     */
    public function pictures()
    {
        return $this->hasMany('App\Models\Picture');
    }

    /**
     * The clients mentioned in the external references of this product group.
     */
    public function clients()
    {
        return $this->belongsToMany('App\Models\Admin\Client')->where('deactivated', 0)->withPivot('reference_name');
    }
}
