<?php

namespace App\Models\Admin;

use Illuminate\Database\Eloquent\Model;

class Client extends Model
{
    //
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = ['created_at', 'updated_at'];

    /**
     * Get the individuals that belongs to this client.
     */
    public function companies()
    {
        return $this->hasMany('App\Models\Admin\ResellerCompany');
    }

    /**
     * Get the individuals that belongs to this client.
     */
    public function individuals()
    {
        return $this->hasMany('App\Models\Admin\Individual');
    }

    /**
     * The discount of this client.
     */
    public function discounts()
    {
        return $this->belongsToMany('App\Models\Admin\Discount')->withPivot('rate')->where('deactivated', 0);
    }

    /**
     * The favourites of this client.
     */
    public function favourites(){
        return $this->hasMany('App\Models\Admin\Favourite', 'client_id');
    }

    /**
     * The Delivery Addresess of this client.
     */
    public function deliveryAddresses()
    {
        return $this->hasMany('App\Models\Admin\DeliveryAddress', 'client_id')->orderBy('by_default','desc')->orderBy('code');
    }
}
