<?php

namespace App\Http\Controllers\Api\Users\Resellers\V1_0;

use App\Http\Controllers\Api\Users\Resellers\V1_0\Command\CommandDecorator;
use App\Http\Controllers\Controller;
use App\Jobs\Mails\Resellers\CommandCreated;
use App\Models\Users\Command;
use App\Models\Users\Client;
use App\Models\Users\Delivery;
use App\Http\Utils\MyLog;
use App\Models\Users\Resellers\DeliveryAddress;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Mail;
use Validator;
use Log;


class CommandController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $user = Auth::user();
        $reseller_id = $user->reseller->id;

        $query = Command::query();

        $query->where('reseller_id', $reseller_id);

        $typeId = null;
        $commandNumber = null;
        $statusId = null;
        $startDate = null;
        $endDate = null;
        $transactionNumber = null;
        if(Input::has('type'))
            $typeId = Input::get('type');
        if(Input::has('number'))
            $commandNumber = Input::get('number');
        if(Input::has('status'))
            $statusId = Input::get('status');
        if(Input::has('start'))
            $startDate = Input::get('start').' '.'00:00:00';
        if(Input::has('end'))
            $endDate = Input::get('end').' '.'23:59:59';
        if(Input::has('transaction_number'))
            $transactionNumber = Input::get('transaction_number');

        // Command Number
        if ($typeId != null)
            $query->where('type_id',$typeId);
        // Command Number
        if ($commandNumber != null)
            $query->where('number','like', '%'.$commandNumber.'%');
        // Status ID
        if ($statusId != null)
            $query->where('status_id', $statusId);
        // Start Date
        if ($startDate != null)
            $query->where('created_at', '>=', $startDate);
        // End Date
        if ($endDate != null)
            $query->where('created_at', '<=', $endDate);
        if ($transactionNumber != null)
            $query->where('transaction_number', '=', $transactionNumber);


        $query->orderBy('id', 'desc');

        $command = $query->with('status', 'delivery')->get();

        if ($transactionNumber != null && $command->isEmpty()) {
            $status = 200;
            $error = 'transaction_number_not_found';
            MyLog::Warning($status, $error, 'Transaction number: '.$transactionNumber);
        }

        return $command;
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $validator = Validator::make($request->all(), [
            'total_ht' => 'required|numeric',
            'total_vat' => 'required|numeric',
            'total_ttc' => 'required|numeric',
            'items' => 'required|array'
        ]);

        if (!$validator->fails()) {
            if (Input::has('delivery')) {
                $deliveryInput = $request->delivery;
                $validator = Validator::make($deliveryInput, [
                    'delivery_address_id' => 'required|numeric'
                ]);
            }
            if (!$validator->fails()) {
                foreach ($request->items as $inputItem) {
                    $validator = Validator::make($inputItem, [
                        'product_id' => 'required|integer',
                        'variant_id' => 'integer',
                        'quantity' => 'required|integer',
                        'total_ttc' => 'required|numeric',
                        'product_price_ttc' => 'required|numeric',
                        'length' => 'nullable|numeric',
                        'width' => 'nullable|numeric',
                        'high' => 'nullable|numeric',
                        'discount_rate' => 'nullable|integer',
                        'total_ttc' => 'required|numeric'
                    ]);
                    if ($validator->fails())
                        break;
                }
            }
        }
        if ($validator->fails()) {
            $status = 400;
            $error = 'validation_error';
            $messages = $validator->errors()->all();
            MyLog::Error($status, $error, null, null, $messages);
            return response()->json(['error' => $error, 'messages' => $messages], $status);
        }

        $user = Auth::user();
        // Command summary storage
        $command = new Command();
        $command->status_id = 10; // Crée
        $command->reseller_id = $user->reseller->id;
        $client_id = $user->reseller->company->client_id;
        $client_ERP_code = Client::findOrFail($client_id)->ERP_code;
        DB::transaction(function () use ($request, $command, $user, $client_id, $client_ERP_code) {
            $inputs = $request->all();
            foreach ($inputs as $key => $value) {
                if ($key != 'client_id' &&
                    $key != 'channel_id' &&
                    $key != 'delivery' &&
                    $key != 'items'
                )
                    $command[$key] = $value;
            }
            $command->client_id = $client_id;
            $command->channel_id = 2;
            $command->save();
            if ($command->type_id == 2)
                $command->number = sprintf("R0%'.07s0%'.010d", $client_ERP_code, $command->id);
            else
                $command->number = sprintf("C0%'.07s0%'.010d", $client_ERP_code, $command->id);
            $command->save();
            // Items storage
            $commandDecorator = new CommandDecorator($command);
            $commandDecorator->decorate($inputs['items']);
            $items = $commandDecorator->getItems();
            foreach ($items as $item) {
                $command->items()->save($item);
            }
            // Delivery information storage
            if (Input::has('delivery')) {
                $delivery = new Delivery();
                $deliveryInput = $request->delivery;
                foreach ($deliveryInput as $key => $value) {
                    $delivery[$key] = $value;
                }
                $deliveryAddress = DeliveryAddress::findOrFail($delivery->delivery_address_id);
                $delivery->delivery_address_code = $deliveryAddress->code;
                $delivery->first_name = $deliveryAddress->first_name;
                $delivery->last_name = $deliveryAddress->last_name;
                $delivery->phone = $deliveryAddress->phone;
                $delivery->adress = $deliveryAddress->address;
                $delivery->adress_followup = $deliveryAddress->address_followup;
                $delivery->town = $deliveryAddress->town;
                $delivery->save();
                $command->delivery()->associate($delivery);
            }
            $command->save();
        });
        // Send mail
        //Mail::to($user->reseller->company->email)->send(new CommandCreated($command));
        $this->dispatch(new CommandCreated($user->reseller->company->email, $command));

        return response()->json(['type_id' => $command->type_id, 'command_number' => $command->number], 200);
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        $user = Auth::user();
        $reseller_id = $user->reseller->id;
        $command = Command::where('reseller_id', $reseller_id)->findOrFail($id);

        $command->status;
        $command->reseller;
        $command->delivery;
        $command->items;
        return $command;
    }
}
