<?php

namespace App\Http\Controllers\Api\Users\Resellers\V1_0\Command;

use App\Models\Users\Resellers\Product;
use App\Models\Users\Variant;
use DB;
use Log;
use Math;


class ItemDecorator
{
    private $item = null;
    private $product_name = '';
    private $discount_ERP_group_code = null;
    private $discount_rate = 0;


    public function __construct($item)
    {
        $this->item = $item;
    }

    public function decorate($inputItem, $client_id)
    {
        $this->fillProduct($inputItem);
        $this->fillVariant($inputItem);
        $product = Product::findOrFail($this->item->product_id);

        $this->fillQuantity($inputItem);
        $this->fillDimensionProperties($product,$inputItem);
        $this->calculateNameDiscountRate($product, $client_id);
        $this->fillOtherProperties($product);
        $this->item->unitary_ttc = $this->calculateUnitaryTTC($product);
        $this->item->total_ttc = $this->calculateTotalTTC($product);
        $this->item->total_ht = $this->calculateTotalHT($product);
        $this->item->total_tva = $this->calculateTotalTVA();
    }

    private function calculatePriceAttrFact($product, $attr) {
        if ($attr == null)
            return 1;

        $attrFact = 0;
        switch ($attr) {
            case 1 : if ($product->saisir_longueur)
                $attrFact = $this->item->length;
                break;
            case 2 :  if ($product->saisir_largeur)
                $attrFact = $this->item->width;
                break;
            case 3 :  if ($product->saisir_hauteur)
                $attrFact = $this->item->high;
                break;
            case 4 : if ($product->saisir_dim_supp_1)
                $attrFact = $this->item->dim_supp_1;
                break;
            case 5 :  if ($product->saisir_dim_supp_2)
                $attrFact = $this->item->dim_supp_2;
                break;
            case 6 : if ($product->saisir_dim_supp_3)
                $attrFact = $this->item->dim_supp_3;
                break;
            case 7 : if ($product->saisir_dim_supp_4)
                $attrFact = $this->item->dim_supp_4;
                break;
            case 8 :  if ($product->saisir_dim_supp_5)
                $attrFact = $this->item->dim_supp_5;
                break;
            default:
                Log::warning('Issue with price_attr1');
        }

        Log::debug('$attr: '.$attr. ' , $attrFact: '.$attrFact);

        return $attrFact;
    }

    private function calculatePriceFact($product) {
        return $this->calculatePriceAttrFact($product, $product->price_attr1) *
                $this->calculatePriceAttrFact($product, $product->price_attr2) *
                $this->calculatePriceAttrFact($product, $product->price_attr3);

    }

    private function calculateGabaritLength() {
        $length = 0.0;

        Log::debug('calculateGabaritLength item:'.$this->item);

        if (isset($this->item->info_supp_1) && $this->item->info_supp_1 != null) {
            //Formule Longueur (Type = G)
            if (strtoupper($this->item->info_supp_1) == "G") {
                if (isset($this->item->dim_supp_1) && $this->item->dim_supp_1 != null) {
                    $length += $this->item->dim_supp_1;
                }
                if (isset($this->item->dim_supp_4) && $this->item->dim_supp_4 != null) {
                    $length += $this->item->dim_supp_4;
                }
            //Formule Longueur (Type = H)
            } else if (strtoupper($this->item->info_supp_1) == "H") {
                if (isset($this->item->dim_supp_1) && $this->item->dim_supp_1 != null) {
                    $length += $this->item->dim_supp_1;
                }
                if (isset($this->item->dim_supp_3) && $this->item->dim_supp_3 != null) {
                    $length += $this->item->dim_supp_3;
                }
            //Formule Longueur (Type <> G, H)
            } else {
                if (!isset($this->item->dim_supp_1) || $this->item->dim_supp_1 == null) {
                    $length = $this->item->dim_supp_2;
                }
                else if (! isset($this->item->dim_supp_2) || $this->item->dim_supp_2 == null) {
                    $length = $this->item->dim_supp_1;
                }
                else {
                    $length = max($this->item->dim_supp_1, $this->item->dim_supp_2);
                }
            }
        }

        Log::debug('calculateGabaritLength length:'.$length);

        return $length;
    }

    private function calculateUnitaryTTC($product)
    {
        $unitaryTTC =  (1 - ($this->discount_rate / 100)) * $product->price_ttc;
        if ($product->non_standard)
            $unitaryTTC *=  $this->calculatePriceFact($product);

        if (isset($this->item->unitary_ttc) && $unitaryTTC != $this->item->unitary_ttc)
            Log::warning('Item total TTC should be equal to '.$unitaryTTC.' whereas total TTC '. $this->item->unitary_ttc.' received');

        return $unitaryTTC;
    }


    private function calculateTotalTTC($product)
    {
        $totalTTC = $this->calculateUnitaryTTC($product);

        if ($product->unit_id == 1)
            $totalTTC *=  $this->item->quantity;
        else if ($product->unit_id == 2)
            if (!$product->non_standard)
                $totalTTC *=  $this->item->length;
            else
                if ($product->is_gabarit)
                    $totalTTC *=  $this->calculateGabaritLength();

        if ($totalTTC != $this->item->total_ttc)
            Log::warning('Item total TTC should be equal to '.$totalTTC.' whereas total TTC '. $this->item->total_ttc.' received');

        return $totalTTC;
    }

    private function calculateTotalHT($product)
    {
        $totalHT = $this->item->total_ttc * (100 / (100 + $product->vat->rate));

        if ($totalHT != $this->item->total_ttc)
            Log::warning('Item total HT should be equal to '.$totalHT.' whereas total HT '. $this->item->total_ht.' received');

        return $totalHT;
    }

    private function calculateTotalTVA()
    {
        $totalTVA = $this->item->total_ttc - $this->item->total_ht;

        if ($totalTVA != $this->item->total_tva)
            Log::warning('Item total TVA should be equal to '.$totalTVA.' whereas total TVA '. $this->item->total_tva.' received');

        return $totalTVA;
    }
    
    private function fillOtherProperties($product){
        $this->item->product_name = $this->product_name;
        $this->item->discount_ERP_group_code = $this->discount_ERP_group_code;
        $this->item->discount_rate = $this->discount_rate;

        $this->item->product_id = $product->id;
        $this->item->saisir_longueur = $product->saisir_longueur;
        $this->item->saisir_largeur = $product->saisir_largeur;
        $this->item->saisir_hauteur = $product->saisir_hauteur;
        $this->item->saisir_dim_supp_1 = $product->saisir_dim_supp_1;
        $this->item->label_dim_supp_1 = $product->label_dim_supp_1;
        $this->item->saisir_dim_supp_2 = $product->saisir_dim_supp_2;
        $this->item->label_dim_supp_2 = $product->label_dim_supp_2;
        $this->item->saisir_dim_supp_3 = $product->saisir_dim_supp_3;
        $this->item->label_dim_supp_3 = $product->label_dim_supp_3;
        $this->item->saisir_dim_supp_4 = $product->saisir_dim_supp_4;
        $this->item->label_dim_supp_4 = $product->label_dim_supp_4;
        $this->item->saisir_dim_supp_5 = $product->saisir_dim_supp_5;
        $this->item->label_dim_supp_5 = $product->label_dim_supp_5;
        $this->item->saisir_info_supp_1 = $product->saisir_info_supp_1;
        $this->item->label_info_supp_1 = $product->label_info_supp_1;
        $this->item->saisir_info_supp_2 = $product->saisir_info_supp_2;
        $this->item->label_info_supp_2 = $product->label_info_supp_2;
        //$this->item->product_name = $product->name;
        $this->item->product_ERP_code = $product->ERP_code;
        $this->item->product_non_standard = $product->non_standard;
        $this->item->product_unit_id = $product->unit_id;
        $this->item->product_type_id = $product->type_id;
        $this->item->product_length = $product->length;
        $this->item->product_width = $product->width;
        $this->item->product_height = $product->high;
        $this->item->product_price_ttc = $product->price_ttc;
        $this->item->product_price_attr1 = $product->price_attr1;
        $this->item->product_price_attr2 = $product->price_attr2;
        $this->item->product_price_attr3 = $product->price_attr3;
        $this->item->product_vat = $product->vat->rate;
    }

    private function fillDimensionProperties($product,$inputItem) {
        if ($product->saisir_longueur == 1 && isset($inputItem['length']))
            $this->item->length = (float) $inputItem['length'];
        if ($product->saisir_largeur == 1 && isset($inputItem['width']))
            $this->item->width = (float) $inputItem['width'];
        if ($product->saisir_hauteur == 1 && isset($inputItem['high']))
            $this->item->high = (float) $inputItem['high'];
        if ($product->saisir_dim_supp_1 == 1 && isset($inputItem['dim_supp_1']))
            $this->item->dim_supp_1 = (float) $inputItem['dim_supp_1'];
        if ($product->saisir_dim_supp_2 == 1 && isset($inputItem['dim_supp_2']))
            $this->item->dim_supp_2 = (float) $inputItem['dim_supp_2'];
        if ($product->saisir_dim_supp_3 == 1 && isset($inputItem['dim_supp_3']))
            $this->item->dim_supp_3 = (float) $inputItem['dim_supp_3'];
        if ($product->saisir_dim_supp_4 == 1 && isset($inputItem['dim_supp_4']))
            $this->item->dim_supp_4 = (float) $inputItem['dim_supp_4'];
        if ($product->saisir_dim_supp_5 == 1 && isset($inputItem['dim_supp_5']))
            $this->item->dim_supp_5 = (float) $inputItem['dim_supp_5'];
        if ($product->saisir_info_supp_1 == 1 && isset($inputItem['info_supp_1']))
            $this->item->info_supp_1 = $inputItem['info_supp_1'];
        if ($product->saisir_info_supp_2 == 1 && isset($inputItem['info_supp_2']))
            $this->item->info_supp_2 = $inputItem['info_supp_2'];
    }

    private function fillQuantity($inputItem) {
        $this->item->quantity = 1;
        if (isset($inputItem['quantity']))
            $this->item->quantity = (float) $inputItem['quantity'];
    }

    private function fillProduct($inputItem) {
        $this->item->product_id = $inputItem['product_id'];
    }

    private function fillVariant($inputItem) {
        if (isset($inputItem['variant_id'])) {
            $this->item->variant_id = $inputItem['variant_id'];
            $variant = Variant::findOrFail($this->item->variant_id);
            $this->item->variant_ERP_code = $variant->ERP_code;
        }
    }

    private function calculateNameDiscountRate($product, $client_id) {
        $query = Product::query();

        $query->select('products.id', 'products.created_at', 'products.updated_at', 'products.deactivated', 'products.visible_individual', 'products.group_id', db::raw('(CASE WHEN client_product.reference_name IS NOT NULL THEN client_product.reference_name ELSE products.name END) AS name'), 'products.ERP_code', 'products.non_standard', 'products.unit_id', 'products.type_id','products.saisir_longueur','products.length','products.saisir_largeur', 'products.width', 'products.saisir_hauteur','products.high','products.saisir_dim_supp_1','products.label_dim_supp_1','products.saisir_dim_supp_2','products.label_dim_supp_2','products.saisir_dim_supp_3','products.label_dim_supp_3','products.saisir_dim_supp_4','products.label_dim_supp_4','products.saisir_dim_supp_5','products.label_dim_supp_5','products.saisir_info_supp_1','products.label_info_supp_1','products.saisir_info_supp_2','products.label_info_supp_2','products.price_ttc', 'products.vat_id', 'products.discount_id','products.specific_client_id',
            db::raw('discounts.ERP_group_code as discount_ERP_group_code'), db::raw('client_discount.rate  as  discount_rate'))
            ->leftJoin('discounts','products.discount_id','=','discounts.id')
            ->leftJoin('client_discount', function ($join) use ($client_id) {
                $join->on('products.discount_id', '=', 'client_discount.discount_id')
                    ->where('client_discount.client_id', '=', $client_id);
            })
            ->leftJoin('client_product', function ($join) use ($client_id) {
                $join->on('client_product.product_id', '=', 'products.id')
                    ->where('client_product.client_id', '=', $client_id);
            })
            ->where('products.id', $product->id);
        $result = $query->get()->first();
        $this->product_name = $result->name;
        $this->discount_ERP_group_code = $result->discount_ERP_group_code;
        $this->discount_rate = $result->discount_rate != null ? $result->discount_rate : 0;
    }

}
