<?php

namespace App\Http\Controllers\Api\Users\Individuals\V1_0;

use App\Http\Controllers\Controller;
use App\Models\Users\Individuals\Product;

class ProductController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        return Product::get();
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return Product::with('group', 'group.pictures', 'unit', 'type', 'vat', 'variants')->findOrFail($id);
    }

}
