<?php

namespace App\Http\Controllers\Api\Users\Individuals\V1_0;

use App\Http\Controllers\Api\Users\Individuals\V1_0\Command\CommandDecorator;
use App\Http\Controllers\Controller;
//use App\Mail\Individuals\CommandCreated;
use App\Jobs\Mails\Individuals\CommandCreated;
use App\Models\Users\Client;
use App\Models\Users\Command;
use App\Models\Users\Delivery;
use App\Http\Utils\MyLog;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Mail;
use Validator;
use Log;


class CommandController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $user = Auth::user();
        $individual_id = $user->individual->id;

        $query = Command::query();

        $query->where('individual_id', $individual_id);

        $commandNumber = null;
        $statusId = null;
        $startDate = null;
        $endDate = null;
        if(Input::has('number'))
            $commandNumber = Input::get('number');
        if(Input::has('status'))
            $statusId = Input::get('status');
        if(Input::has('start'))
            $startDate = Input::get('start').' '.'00:00:00';
        if(Input::has('end'))
            $endDate = Input::get('end').' '.'23:59:59';

        // Command Number
        if ($commandNumber != null)
            $query->where('number','like', '%'.$commandNumber.'%');
        // Status ID
        if ($statusId != null)
            $query->where('status_id', $statusId);
        // Start Date
        if ($startDate != null)
            $query->where('created_at', '>=', $startDate);
        // End Date
        if ($endDate != null)
            $query->where('created_at', '<=', $endDate);

        $query->orderBy('id', 'desc');

        return $query->with('status')->get();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $validator = Validator::make($request->all(), [
            'total_ht' => 'required|numeric',
            'total_vat' => 'required|numeric',
            'total_ttc' => 'required|numeric',
            'items' => 'required|array'
        ]);

        if (!$validator->fails()) {
            if (Input::has('delivery')) {
                $deliveryInput = $request->delivery;
                $validator = Validator::make($deliveryInput, [
                    'first_name' => 'required|min:3|max:20|regex:/^[(\p{L} \-\')]+$/u',
                    'last_name' => 'required|min:3|max:20|regex:/^[(\p{L} \-\')]+$/u',
                    'phone' => 'required|digits:10',
                    'adress' => 'required|min:3|max:200|regex:/^[(\d\p{L} \-\',.)]+$/u',
                    'adress_followup' => 'min:3|max:20|regex:/^[(\d\p{L} \-\',.)]+$/u',
                    'town' => 'required|min:3'
                ]);
            }
            if (!$validator->fails()) {
                foreach ($request->items as $inputItem) {
                    $validator = Validator::make($inputItem, [
                        'product_id' => 'required|integer',
                        'variant_id' => 'required|integer',
                        'quantity' => 'required|integer',
                        'total_ttc' => 'required|numeric',
                        'product_price_ttc' => 'required|numeric',
                        'length' => 'nullable|numeric',
                        'width' => 'nullable|numeric',
                        'high' => 'nullable|numeric',
                        'discount_rate' => 'nullable|integer',
                        //'product_vat' => 'required|integer',
                        //'total_ht' => 'required|numeric',
                        'total_ttc' => 'required|numeric'
                    ]);
                    if ($validator->fails())
                        break;
                }
            }
        }
        if ($validator->fails()) {
            $status = 400;
            $error = 'validation_error';
            $messages = $validator->errors()->all();
            MyLog::Error($status, $error, null, null, $messages);
            return response()->json(['error' => $error, 'messages' => $messages], $status);
        }

        $user = Auth::user();
        // Command summary storage
        $command = new Command();
        $command->individual_id = $user->individual->id;
        $client_id = $user->individual->client_id;
        $client_ERP_code = Client::findOrFail($client_id)->ERP_code;
        DB::transaction(function () use ($request, $command, $client_ERP_code) {
            $inputs = $request->all();
            foreach ($inputs as $key => $value) {
                if ($key != 'delivery' &&
                    $key != 'items'
                )
                    $command[$key] = $value;
            }
            $command->save();
            $command->number = sprintf("C0%'.07s0%'.010d", $client_ERP_code, $command->id);
            $command->save();
            // Items storage
            $commandDecorator = new CommandDecorator($command);
            $commandDecorator->decorate($inputs['items']);
            $items = $commandDecorator->getItems();
            foreach ($items as $item) {
                $command->items()->save($item);
            }
            // Delivery information storage
            if (Input::has('delivery')) {
                $deliveryInput = $inputs['delivery'];
                $delivery = new Delivery();
                foreach ($deliveryInput as $key => $value) {
                    $delivery[$key] = $value;
                }
                $delivery->save();
                $command->delivery()->associate($delivery);
                $command->save();
            }
        });

        // Send mail
        //Mail::to($user->email)->send(new CommandCreated($command));
        $this->dispatch(new CommandCreated($user->email, $command));

        return response()->json(['command_number' => $command->number,'ttc_total'=>$command->ttc_total], 200);
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        $user = Auth::user();
        $individual_id = $user->individual->id;
        $command = Command::where('individual_id', $individual_id)->findOrFail($id);

        $command->status;
        $command->individual;
        $command->delivery;
        $command->items;
        return $command;
    }

    public function update_status($number)
    {
        $command = Command::where('number', $number)->first();
        if($command) {
            $command->status_id = 20;
            $command->save();
        }
        /*
        // Individual case: send another mail
        if ($command->channel->id == 1) {
            $user = $command->individual->user;
            //Mail::to($user->email)->send(new CommandCreated($command));
            $this->dispatch(new CommandCreated($user->email, $command));
        }
        */
    }

    public function send_mail($number)
    {
        $command = Command::where('number', $number)->first();

        Log::debug('send_mail command: '.$command);
        // Individual case: send another mail
        if ($command != null && $command->channel->id == 1) {
            if ($command->individual != null) {
                $user = $command->individual->user;
                Log::debug('$user->email: ' . $user->email);
                //Mail::to($user->email)->send(new CommandCreated($command));
                $this->dispatch(new CommandCreated($user->email, $command));
            }
            else {
                Log::debug('Individual not found: '.$command->individual_id);
            }
        }
    }
}
