<?php

namespace App\Http\Controllers\Api\Admin\V1_0;

use App\Http\Controllers\Controller;
use App\Http\Utils\Miscellaneous;
use App\Http\Utils\MyLog;
use App\Models\Admin\Category;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Input;
use DB;

class CategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $inputs = Input::get();

        if (isset($inputs['pagination_per_page']))
            return Category::paginate($inputs['pagination_per_page']);
        else if (!isset($inputs['pagination_per_page']) && isset($inputs['page']))
            return Category::paginate();
        else if (!isset($inputs['pagination_per_page']) && !isset($inputs['page']))
            return Category::all();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $warning = null;
        $category_stored = Category::where('name', $request->name)->first();
        if ($category_stored != null)
            $warning = 'category_already_exists_name';
        if ($warning != null) {
            $status = 409;
            $message = Lang::get('messages.'.$warning);
            MyLog::Warning($status, $warning, $message);
            return response()->json(['error' => $warning, 'message' => $message], $status);
        }


        $category = new Category;
        $inputs = $request->all();
        DB::transaction(function () use ($category, $inputs) {
            foreach ($inputs as $key => $value) {
                $category[$key] = $value;
            }
            $category->save();
            Miscellaneous::incrementVersion();
        });
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        $category = Category::findOrFail($id);
        $category->groups;

        return $category;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $category = Category::findOrFail($id);
        $warning = null;

        if (Input::has('name'))
            $category->name = Input::get('name');
        $categories_stored = Category::where('name', $category->name);
        $categories_stored_count = $categories_stored->count();
        if ($categories_stored_count == 1) {
            if ($category->id != $categories_stored->first()->id)
                $warning = 'category_already_exists_name';
        }
        else if ($categories_stored_count > 1)
            $warning = 'category_already_exists_name';
        if ($warning != null) {
            $status = 409;
            $message = Lang::get('messages.'.$warning);
            MyLog::Warning($status, $warning, $message);
            return response()->json(['error' => $warning, 'message' => $message], $status);
        }

        $inputs = $request->all();
        DB::transaction(function () use ($category, $inputs) {
            foreach ($inputs as $key => $value) {
                $category[$key] = $value;
            }
            $category->save();
            Miscellaneous::incrementVersion();
        });
    }

}
