/**
 * Created by majid on 29/01/2017.
 */

(function () {
    'use strict';

    angular.module('BlurAdmin.pages.utilisateurs.utilisateurs_revendeurs', [])
        .config(routeConfig);

    /** @ngInject */
    function routeConfig($stateProvider) {
        $stateProvider
            .state('utilisateurs.utilisateurs_revendeurs', {
                url: '/utilisateurs_revendeurs',
                templateUrl: 'app/pages/utilisateurs/utilisateurs_revendeurs/utilisateurs_revendeurs.html',
                title: 'Employés',
                sidebarMeta: {
                    icon: 'glyphicon-th-list',
                    order: 200,
                },
                controller: function ($scope, $stateParams, $http, $state) {
                    if(!$scope.isLogged())
                        window.location.replace('/#/login');

                    $('#Loaderdiv').hide();
                    $('#divTable').hide();
                    $('#divEmpty').hide();
                    $('#msgError').hide();

                    getClients();
                    getCompanies();

                    $scope.revendeurs          = [];
                    $scope.totalRevendeurs     = 0;
                    $scope.revendeursPerPage   = 25;
                    $scope.pageChanged = function(newPage) {
                        getRevendeurs(newPage);
                    };
                    $scope.searchCommand = function (pageNumber) {
                        $('#Loaderdiv').show();
                        $('#divTable').hide();
                        $('#divEmpty').hide();
                        $('#msgError').hide();
                        console.log("getParamsSearch",getParamsSearch())
                        var url = $scope.url+"resellers?pagination_per_page=25&page="+pageNumber;
                        $http({
                            method: 'GET',
                            url: url,
                            params : getParamsSearch(),
                            headers: {
                                "Content-Type": "application/json;charset=UTF-8",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {
                            $('#Loaderdiv').hide();
                            $('#divTable').show();
                            if(response.status == 200) {
                                $scope.totalRevendeurs = response.data.total;
                                $scope.revendeurs = response.data.data;
                                if($scope.revendeurs.length < 1){
                                    $('#divTable').hide();
                                    $('#divEmpty').show();
                                    $('#msgError').hide();
                                } else {
                                    $('#divTable').show();
                                    $('#divEmpty').hide();
                                    $('#msgError').hide();
                                }

                            } else {
                                $scope.error_response = $scope.getErrorMessage(response);
                                $('#divTable').hide();
                                $('#msgError').show();
                            }

                        }, function errorCallback(response) {
                            $scope.revendeurs ={};
                            $scope.error_response = $scope.getErrorMessage(response);
                            $('#Loaderdiv').hide();
                            $('#divTable').hide();
                            $('#msgError').show();

                        });
                    }
                    function getRevendeurs(pageNumber) {
                        var url = $scope.url+"resellers?pagination_per_page=25&page="+pageNumber;
                        $http({
                            method: 'GET',
                            url: url,
                            params : getParamsSearch(),
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {
                            $('#Loaderdiv').hide();
                            if(response.status == 200) {
                                $scope.totalRevendeurs = response.data.total;
                                $scope.revendeurs = response.data.data;
                                $('#divTable').show();
                                $('#msgError').hide();
                            } else {
                                $scope.error_response = $scope.getErrorMessage(response);
                                $('#divTable').hide();
                                $('#msgError').show();
                            }

                        }, function errorCallback(response) {
                            $scope.error_response = $scope.getErrorMessage(response);
                            $('#Loaderdiv').hide();
                            $('#divTable').hide();
                            $('#msgError').show();
                        });
                    }
                    function getClients() {
                        var url = $scope.url+"clients";
                        $http({
                            method: 'GET',
                            url: url,
                            headers: {
                                "Content-Type": "application/json;charset=UTF-8",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {

                            if(response.status == 200) {
                                $scope.clients = response.data;
                            }

                        }, function errorCallback(response) {

                        });
                    }

                    function getCompanies() {
                        var url = $scope.baseUrl+"/api/admin/v1_0/resellerCompanies";
                        $http({
                            method: 'GET',
                            url: url,
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {
                            if(response.status == 200)
                                $scope.companies = response.data;
                            else
                                $scope.reror_status = "Une erreur s'est produite, merci de réessayer.";

                        }, function errorCallback(response) {
                            $scope.reror_status = "Une erreur s'est produite, merci de réessayer.";
                        });
                    }
                    $scope.deactivateUser = function (id, val) {
                        $('#msgError').hide();
                        $scope.reseller_data_deactive = {
                            deactivated  : val
                        };
                        var url = $scope.url+"resellers/"+id;
                        $http({
                            method  : 'PUT',
                            url     : url,
                            data  :  $.param($scope.reseller_data_deactive),
                            headers : {
                                "Content-Type": "application/x-www-form-urlencoded",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {

                            if(response.status == 200){
                                $('#msgTop').show();
                                getRevendeurs($scope.pagination.current);
                            } else {
                                $scope.error_response = $scope.getErrorMessage(response);
                                $('#msgError').show();
                            }

                        }, function errorCallback(response) {
                            $scope.error_response = $scope.getErrorMessage(response);
                            $('#msgError').show();
                        });
                    };
                    function getParamsSearch() {

                        var paramsSearch = {};

                        var lastName  = {last_name : $scope.lastNameMdl};
                        var firstName   = {first_name  : $scope.firstNameMdl};
                        var town       = {town : $scope.townMdl};
                        var companyName = {company_id : $scope.companyNameMdl};
                        var codeClient = {client_id : $scope.codeClientMdl};
                        if(!$scope.lastNameMdlBox)
                            paramsSearch = angular.extend({},paramsSearch, lastName)
                        if(!$scope.firstNameMdlBox)
                            paramsSearch = angular.extend({},paramsSearch, firstName)
                        if(!$scope.townMdlBox)
                            paramsSearch = angular.extend({},paramsSearch, town)
                        if(!$scope.companyNameMdlBox)
                            paramsSearch = angular.extend({},paramsSearch, companyName)
                        if(!$scope.codeClientMdlBox)
                            paramsSearch = angular.extend({},paramsSearch, codeClient)
                        return paramsSearch;
                    }
                    $scope.checkLastName = function (val) {
                        $scope.lastNameMdl = val;
                    };
                    $scope.checkLastNameBox = function (val) {
                        console.log("iiiiinn",$scope.checkLastNameMdlBox)
                        $scope.lastNameMdlBox = val;
                        if($scope.lastNameMdlBox==true) $('#lastNameMdl').val("");
                    };
                    $scope.checkFirstName = function (val) {
                        $scope.firstNameMdl = val;
                    };
                    $scope.checkFirstNameBox = function (val) {
                        $scope.firstNameMdlBox = val;
                        if($scope.firstNameMdlBox==true) $('#firstNameMdl').val("");
                    };
                    $scope.checkCompanyName = function (val) {
                        $scope.companyNameMdl = val;
                    };
                    $scope.checkCompanyNameBox = function (val) {
                        $scope.companyNameMdlBox = val;
                        if($scope.companyNameMdlBox==true) $('#companyNameMdl').val("");
                    };
                    $scope.checkCodeClient = function (val) {
                        $scope.codeClientMdl = val;
                    };
                    $scope.checkCodeClientBox = function (val) {
                        $scope.codeClientMdlBox = val;
                        if($scope.codeClientMdlBox==true) $('#codeClientMdl').val("");
                    };
                    $scope.checkTown = function (val) {
                        $scope.townMdl = val;
                    };
                    $scope.checkTownBox = function (val) {
                        $scope.townMdlBox = val;
                        if($scope.townMdlBox==true) $('#townMdl').val("");
                    };

                }

        }).state('consultationUtilisateur', {
            url: '/consultationUtilisateur',
            params: {id: null},
            templateUrl: 'app/pages/utilisateurs/utilisateurs_revendeurs/consultationUtilisateur/consultationUtilisateur.html',
            title: 'Consultation Utilisateur',
            controller: function ($scope, $http, $stateParams, $state) {
                if (!$scope.isLogged())
                    window.location.replace('/#/login');

                if ($stateParams.id != null)
                    $scope.putCoockie('parmsID', $stateParams.id);
                console.log("id_consultation",$stateParams)
                $('#Loaderdiv').show();
                $('#divTable').hide();
                $('#msgError').hide();

                function getUser() {
                    var url = $scope.url+"resellers/"+$scope.getCoockie('parmsID');
                    $http({
                        method: 'GET',
                        url: url,
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {
                        $('#Loaderdiv').hide();
                        $('#divTable').show();
                        $('#msgError').hide();
                        if(response.status == 200){
                            $scope.detailUtilisateur = response.data;
                            $scope.nameMdl         = $scope.detailUtilisateur.last_name ;
                            $scope.prenomMdl       = $scope.detailUtilisateur.first_name ;
                            $scope.mobileMdl         = $scope.detailUtilisateur.mobile ;
                            $scope.loginMdl        = $scope.detailUtilisateur.user.email ;
                            $scope.passwordMdl        = $scope.detailUtilisateur.user.password ;
                            $scope.visiblePrice      =$scope.booleanToInteger(detailUtilisateur.price_visibility);
                        } else {
                            $scope.error_response = $scope.getErrorMessage(response);
                            $('#divTable').hide();
                            $('#msgError').show();
                        }

                    }, function errorCallback(response) {

                        $scope.error_response = $scope.getErrorMessage(response);
                        $('#divTable').hide();
                        $('#msgError').show();
                        $('#Loaderdiv').hide();
                    });
                }
                getUser();
            }
         }).state('updateUtilisateur', {
            url: '/updateUtilisateur',
            params: {id : null},
            templateUrl: 'app/pages/utilisateurs/utilisateurs_revendeurs/updateUtilisateur/updateUtilisateur.html',

            controller: function ($scope,$http,$stateParams, $state) {
                if(!$scope.isLogged())
                    window.location.replace('/#/login');
                if($stateParams.id != null)
                    $scope.putCoockie('idUser', $stateParams.id);
                $('#Loaderdiv').show();
                $('#divTable').hide();
                $('#msgTop').hide();
                $('#msgError').hide();
                function getUser() {
                    var url = $scope.url+"resellers/"+$scope.getCoockie('idUser');
                    $http({
                        method: 'GET',
                        url: url,
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {
                        $('#Loaderdiv').hide();
                        $('#divTable').show();
                        $('#msgError').hide();
                        if(response.status == 200){
                            $scope.detailUtilisateur = response.data;
                           $scope.nomMdl         = $scope.detailUtilisateur.last_name ;
                            $scope.prenomMdl       = $scope.detailUtilisateur.first_name ;
                            $scope.mobileMdl         = $scope.detailUtilisateur.mobile ;
                            $scope.loginMdl        = $scope.detailUtilisateur.user.email ;
                            $scope.passwordMdl        = $scope.detailUtilisateur.user.password ;
                            //$scope.visiblePrice      =$scope.booleanToInteger(detailUtilisateur.price_visibility);
                        } else {
                            $scope.error_response = $scope.getErrorMessage(response);
                            $('#divTable').hide();
                            $('#msgError').show();
                        }

                    }, function errorCallback(response) {

                        $scope.error_response = $scope.getErrorMessage(response);
                        $('#divTable').hide();
                        $('#msgError').show();
                        $('#Loaderdiv').hide();
                    });
                }
                getUser();
                $scope.updateUser = function () {

                    $('#msgBottom').hide();
                    $('#LoaderdivBottom').show();

                    $scope.reseller_data = {
                        user: {
                            login: $scope.loginMdl,
                            password: $scope.passwordMdl
                        },
                        first_name: $scope.prenomMdl,
                        last_name: $scope.nomMdl,
                        mobile: $scope.mobileMdl,
                        price_visibility: $scope.booleanToInteger($scope.visiblePrice),
                        deactivated:$scope.booleanToInteger($scope.activatedMDL)
                    };
                    console.log('heeeeeeere',$scope.visiblePrice)
                    var url = $scope.url+"resellers/"+$scope.getCoockie('idUser');
                    $http({
                        method: 'PUT',
                        url: url,
                        data :  $.param($scope.reseller_data),
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {
                        $('#msgBottom').hide();
                        $('#LoaderdivBottom').hide();
                        if(response.status == 200)
                            window.location.replace('/#/utilisateurs/utilisateurs_revendeurs');
                        else
                            $scope.response_error = "Une erreur s'est produite, merci de réessayer.";

                    }, function errorCallback(response) {
                        $('#msgBottom').show();
                        $('#LoaderdivBottom').hide();
                        $scope.error_add_revendeur = $scope.getErrorMessage(response);
                    });
                }
                $scope.checkVisible = function(val) {
                    $scope.visiblePrice = val ;
                    console.log("visible", $scope.visiblePrice)
                }
                $scope.checknom = function(val) {
                    $scope.nomMdl = val ;
                }
                $scope.checkprenom = function(val) {
                    $scope.prenomMdl = val ;
                }
                $scope.checkmobile = function(val) {
                    $scope.mobileMdl = val ;
                }
                $scope.checkActivate = function(val) {
                    $scope.activatedMDL = val ;
                }
                $scope.checklogin = function(val) {
                    $scope.loginMdl = val ;
                }
            }

        });
    }

})();
