/**
 * Created by majid on 29/01/2017.
 */

(function () {
    'use strict';

    angular.module('BlurAdmin.pages.utilisateurs.particuliers', [])
        .config(routeConfig);

    /** @ngInject */
    function routeConfig($stateProvider) {
        $stateProvider
            .state('utilisateurs.particuliers', {
                url: '/particuliers',
                templateUrl: 'app/pages/utilisateurs/particuliers/particuliers.html',
                title: 'Particuliers',
                sidebarMeta: {
                    icon: 'glyphicon-th-list',
                    order: 300,
                },
                controller: function ($scope, $stateParams, $http, $state) {
                    if(!$scope.isLogged())
                        window.location.replace('/#/login');

                    $scope.users = [];
                    $scope.totalUsers = 0;
                    $scope.usersPerPage = 25;
                    $scope.pageChanged = function(newPage) {
                        getParticuliers(newPage);
                    };

                    $('#Loaderdiv').hide();
                    $('#divTable').hide();
                    $('#divEmpty').hide();
                    $('#msgError').hide()
                    $scope.searchCommand = function (pageNumber) {
                        $('#Loaderdiv').show();
                        $('#divTable').hide();
                        $('#divEmpty').hide();
                        $('#msgError').hide();
                        console.log("getParamsSearch",getParamsSearch())
                        var url = $scope.url+"individuals?pagination_per_page=25&page="+pageNumber;
                        $http({
                            method: 'GET',
                            url: url,
                            params : getParamsSearch(),
                            headers: {
                                "Content-Type": "application/json;charset=UTF-8",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {
                            $('#Loaderdiv').hide();
                            $('#divTable').show();
                            if(response.status == 200) {
                                $scope.users = response.data.data;
                                $scope.totalUsers = response.data.total;
                                if($scope.users.length < 1){
                                    $('#divTable').hide();
                                    $('#divEmpty').show();
                                    $('#msgError').hide();
                                } else {
                                    $('#divTable').show();
                                    $('#divEmpty').hide();
                                    $('#msgError').hide();
                                }

                            } else {
                                $scope.error_response = $scope.getErrorMessage(response);
                                $('#divTable').hide();
                                $('#msgError').show();
                            }

                        }, function errorCallback(response) {
                            $scope.users ={};
                            $scope.error_response = $scope.getErrorMessage(response);
                            $('#Loaderdiv').hide();
                            $('#divTable').hide();
                            $('#msgError').show();

                        });
                    }
                    function getStatuses () {

                        var url = $scope.baseUrl+"/api/users/individuals/v1_0/towns";
                        $http({
                            method: 'GET',
                            url: url,
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {
                            if(response.status == 200)
                                $scope.towns = response.data;
                            else
                                $scope.reror_status = "Une erreur s'est produite, merci de réessayer.";

                        }, function errorCallback(response) {
                            $scope.reror_status = "Une erreur s'est produite, merci de réessayer.";
                        });
                    }
                    getStatuses();
                    function getClients() {
                        var url = $scope.url+"clients";
                        $http({
                            method: 'GET',
                            url: url,
                            headers: {
                                "Content-Type": "application/json;charset=UTF-8",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {

                            if(response.status == 200) {
                                $scope.clients = response.data;
                            }

                        }, function errorCallback(response) {

                        });
                    }
                    getClients();
                    function getParticuliers(pageNumber) {
                        var url = $scope.url+"individuals?pagination_per_page=25&page="+pageNumber;
                        $http({
                            method: 'GET',
                            url: url,
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {
                            $('#Loaderdiv').hide();
                            if(response.status == 200) {
                                $scope.users = response.data.data;

                                $scope.totalUsers = response.data.total;
                                $('#divTable').show();
                                $('#msgError').hide();
                            } else {
                                $scope.error_response = $scope.getErrorMessage(response);
                                $('#divTable').hide();
                                $('#msgError').show();
                            }
                        }, function errorCallback(response) {
                            $scope.error_response = $scope.getErrorMessage(response);
                            $('#Loaderdiv').hide();
                            $('#divTable').hide();
                            $('#msgError').show();
                        });
                    }
                    $scope.deactivateParticulier = function (id, val) {
                        $('#msgError').hide();
                        var particular_data = {
                            deactivated  : val
                        };
                        var url = $scope.url+"individuals/"+id;
                        $http({
                            method  : 'PUT',
                            url     : url,
                            data :  $.param(particular_data),
                            headers : {
                                "Content-Type": "application/x-www-form-urlencoded",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {

                            if(response.status == 200){
                                $('#msgTop').show();
                                getParticuliers($scope.pagination.current);
                            } else {
                                $scope.error_response = $scope.getErrorMessage(response);
                                $('#msgError').show();
                            }

                        }, function errorCallback(response) {
                            $scope.error_response = $scope.getErrorMessage(response);
                            $('#msgError').show();
                        });
                    }
                    function getParamsSearch() {

                        var paramsSearch = {};

                        var status        = {town_id      : $scope.stateModel};
                        var name          = {last_name  : $scope.nameMdl};
                        var codeClient    = {client_id      : $scope.codeClientMdl};

                        if(!$scope.stateModelBox)
                            paramsSearch = angular.extend({},paramsSearch, status)

                        if(!$scope.nameMdlBox)
                            paramsSearch = angular.extend({},paramsSearch, name)
                        if(!$scope.codeClientMdlBox)
                            paramsSearch = angular.extend({},paramsSearch, codeClient)
                        return paramsSearch;
                    }
                    //getParticuliers($scope.pagination.currentParticulier);
                    $scope.checkCode = function (val) {
                        $scope.codeModel = val;
                    };
                    $scope.checkCodeBox = function (val) {
                        $scope.codeModelBox = val;
                        if($scope.codeModelBox==true) $('#codeModel').val("");
                    };
                    $scope.checkName = function (val) {
                        $scope.nameMdl = val;
                    };
                    $scope.checkNameBox = function (val) {
                        $scope.nameMdlBox = val;
                        if($scope.nameMdlBox==true) $('#nameMdl').val("");
                    };
                    $scope.checkCodeClient = function (val) {
                        $scope.codeClientMdl = val;
                    };
                    $scope.checkCodeClientBox = function (val) {
                        $scope.codeClientMdlBox = val;
                        if($scope.checkCodeClientBox==true) $('#codeClientMdl').val("");
                    };
                    $scope.checkStatus = function (val) {
                        $scope.stateModel = val;
                    };
                    $scope.checkStatusBox = function (val) {
                        $scope.stateModelBox = val;
                        if($scope.stateModelBox==true) $('#stateModel').val("");
                    };
                }

            }).state('consultationParticulier', {
            url: '/consultationParticulier',
            params: {id : null},
            templateUrl    : 'app/pages/utilisateurs/particuliers/consultationParticulier/consultationParticulier.html',
            title: 'Consultation Particulier',
            controller: function ($scope, $http, $stateParams, $state) {
                if(!$scope.isLogged())
                    window.location.replace('/#/login');

                if($stateParams.id != null)
                    $scope.putCoockie('parmsID', $stateParams.id);

                $('#Loaderdiv').show();
                $('#divTable').hide();
                $('#msgError').hide();
                function getParticulier() {
                    var url = $scope.url+"individuals/"+$scope.getCoockie('parmsID');
                    $http({
                        method: 'GET',
                        url: url,
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {
                        $('#Loaderdiv').hide();
                        $('#divTable').show();
                        $('#msgError').hide();
                        if(response.status == 200) {
                            $('#divTable').show();
                            $('#msgError').hide();
                            $scope.detailParticulier = response.data;
                            $scope.cltMdl            = $scope.detailParticulier.client.ERP_code;
                            $scope.adressMdl         = $scope.detailParticulier.adress;
                            $scope.activatedMDL      = $scope.detailParticulier.deactivated;
                        } else {
                            $scope.error_response = $scope.getErrorMessage(response);
                            $('#divTable').hide();
                            $('#msgError').show();
                        }

                    }, function errorCallback(response) {
                        $scope.error_response = $scope.getErrorMessage(response);
                        $('#Loaderdiv').hide();
                        $('#divTable').hide();
                        $('#msgError').show();
                    });
                }
                getParticulier();
            }
        }).state('addParticulier', {
            url: '/addParticulier',
            templateUrl    : 'app/pages/utilisateurs/particuliers/addParticulier/addParticulier.html',
            title: 'Ajouter Particulier',
            controller: function ($scope, $http, $stateParams, $state) {
                if(!$scope.isLogged())
                    window.location.replace('/#/login');

                $('#msgBottom').hide();
                $('#LoaderdivBottom').hide();

                $scope.addRevendeur = function () {
                    $('#msgBottom').hide();
                    $('#LoaderdivBottom').show();
                    $scope.reseller_data = {
                        deactivated  : $scope.booleanToInteger($scope.activatedMDL),
                        client_id    : $scope.cltMdl,
                        name         : $scope.nameMdl,
                        zip_code     : $scope.postalMdl,
                        town         : $scope.townMdl,
                        user         : {
                            email        : $scope.emailMdl,
                            password     : $scope.passwordMdl
                        }
                    };
                    var url = $scope.url+"individuals";
                    $http({
                        method: 'POST',
                        url: url,
                        data :  $.param($scope.reseller_data),
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {

                        if(response.status == 200)
                            window.location.replace('/#/utilisateurs/revendeurs');
                        else {
                            $('#msgBottom').show();
                            $('#LoaderdivBottom').hide();
                            $scope.error_response = $scope.getErrorMessage(response);
                        }

                    }, function errorCallback(response) {

                        $('#msgBottom').show();
                        $('#LoaderdivBottom').hide();
                        $scope.error_response = $scope.getErrorMessage(response);
                    });
                }
                // Get clients
                function getClients() {
                    var url = $scope.url+"clients";
                    $http({
                        method: 'GET',
                        url: url,
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {
                        if(response.status == 200) {
                            $scope.clients = response.data;
                            $scope.cltMdl = $scope.clients[0].id;
                        } else
                            $scope.response_error = "Une erreur s'est produite, merci de réessayer.";

                    }, function errorCallback(response) {

                        $scope.response_error = response.data.message;
                    });
                }

                getClients();
                $scope.checkActivate = function(val) {
                    $scope.activatedMDL = val ;
                }
                $scope.checkName = function(val) {
                    $scope.nameMdl = val ;
                }
                $scope.checkPostal = function(val) {
                    $scope.postalMdl = val ;
                }
                $scope.checkTown = function(val) {
                    $scope.townMdl = val ;
                }
                $scope.checkEmail = function(val) {
                    $scope.emailMdl = val ;
                }

                $scope.checkPassword = function(val) {
                    $scope.passwordMdl = val ;
                }

                $scope.checkClient = function(val) {
                    $scope.cltMdl = val ;
                }

            }
        }).state('updateParticulier', {
            url: '/updateParticulier',
            params: {id : null},
            templateUrl    : 'app/pages/utilisateurs/particuliers/updateParticulier/updateParticulier.html',
            title: 'Consultation Revendeurs',
            controller: function ($scope, $http, $stateParams, $state) {
                if(!$scope.isLogged())
                    window.location.replace('/#/login');
                if($stateParams.id != null)
                    $scope.putCoockie('parmsID', $stateParams.id);

                $('#Loaderdiv').show();
                $('#divTable').hide();
                $('#msgBottom').hide();
                $('#LoaderdivBottom').hide();
                $('#msgError').hide();
                function getParticulier() {
                    $('#msgError').hide();
                    var url = $scope.url+"individuals/"+$scope.getCoockie('parmsID');
                    $http({
                        method: 'GET',
                        url: url,
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {
                        $('#Loaderdiv').hide();
                        $('#divTable').show();
                        if(response.status == 200){
                            $scope.detailParticulier = response.data;
                            $scope.cltMdl          = $scope.detailParticulier.client.ERP_code;
                            $scope.nameMdl         = $scope.detailParticulier.last_name;
                            $scope.prenomMdl       =$scope.detailParticulier.first_name ;
                            $scope.townMdl         = $scope.detailParticulier.town.id ;
                            $scope.emailMdl1        = $scope.detailParticulier.user.email ;
                            $scope.postalMdl1=$scope.detailParticulier.zip_code;
                            $scope.idMdl=$scope.detailParticulier.id;
                            $scope.mobileMdl=$scope.detailParticulier.mobile;
                            $scope.adresseMdl=$scope.detailParticulier.adress;
                        } else {
                            $scope.response_error = "Une erreur s'est produite, merci de réessayer.";
                            $('#msgError').show();
                        }

                    }, function errorCallback(response) {
                        $('#Loaderdiv').hide();
                        $('#divTable').show();
                        $scope.response_error = response;
                        $('#msgError').show();
                    });
                }
                getParticulier();
                function getStatuses () {

                    var url = $scope.baseUrl+"/api/users/individuals/v1_0/towns";
                    $http({
                        method: 'GET',
                        url: url,
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {
                        if(response.status == 200)
                            $scope.towns = response.data;
                        else
                            $scope.reror_status = "Une erreur s'est produite, merci de réessayer.";

                    }, function errorCallback(response) {
                        $scope.reror_status = "Une erreur s'est produite, merci de réessayer.";
                    });
                }
                getStatuses();
                $scope.updateRevendeur = function () {
                    $('#msgBottom').hide();
                    $('#LoaderdivBottom').show();
                    $scope.reseller_data = {
                        deactivated  : $scope.booleanToInteger($scope.activatedMDL),
                        //client_id    : $scope.cltMdl,
                        last_name         : $scope.nameMdl,
                        first_name         : $scope.prenomMdl,
                        zip_code     : $scope.postalMdl,
                        town_id         : $scope.townMdl,
                        adress: $scope.adresseMdl,
                        mobile:$scope.mobileMdl
                    };
                    var url = $scope.url+"individuals/"+$scope.getCoockie('parmsID');
                    $http({
                        method: 'PUT',
                        url: url,
                        data :  $.param($scope.reseller_data),
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {

                        if(response.status == 200)
                            window.location.replace('/#/utilisateurs/particuliers');
                        else {
                                $('#msgBottom').show();
                                $('#LoaderdivBottom').hide();
                                $scope.error_response = $scope.getErrorMessage(response);
                        }

                    }, function errorCallback(response) {
                        $('#msgBottom').show();
                        $('#LoaderdivBottom').hide();
                        $scope.error_response = $scope.getErrorMessage(response);
                    });
                }
                // Get clients
                function getClients() {
                    var url = $scope.url+"clients";
                    $http({
                        method: 'GET',
                        url: url,
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {
                        if(response.status == 200) {
                            $scope.clients = response.data;
                        } else
                            $scope.response_error = "Une erreur s'est produite, merci de réessayer.";

                    }, function errorCallback(response) {

                        $scope.response_error = response.data.message;
                    });
                }

                getClients();
                $scope.checkActivate = function(val) {
                    $scope.activatedMDL = val ;
                }
                $scope.checkName = function(val) {
                    $scope.nameMdl = val ;
                }
                $scope.checkPostal = function(val) {
                    $scope.postalMdl = val ;
                }
                $scope.checkTown = function(val) {
                    $scope.townMdl = val ;
                }
                $scope.checkEmail = function(val) {
                    $scope.emailMdl1 = val ;
                }

                $scope.checkClient = function(val) {
                    $scope.cltMdl = val ;
                }
                $scope.checkPrenom = function(val) {
                    $scope.prenomMdl = val ;
                }
                $scope.checkMobile = function(val) {
                    $scope.mobileMdl = val ;
                }
                $scope.checkAdresse = function(val) {
                    $scope.adresseMdl = val ;
                }

            }
        });
    }

})();
