/**
 * Created by majid on 18/01/2017.
 */
(function () {
    'use strict';

    angular.module('BlurAdmin.pages.login', [])
        .config(routeConfig);

    /** @ngInject */
    function routeConfig($stateProvider) {
        $stateProvider
            .state('login', {
                url: '/login',
                templateUrl: 'app/pages/login/login.html',
                title: 'Login',
                controller: function ($scope, $stateParams, $http, $state) {
                    $('#Loaderdiv').hide();
                    // if user is logged redirect to dashboard
                    if($scope.isLogged())
                        window.location.replace('/#/acceuil');

                    $scope.login = function() {
                        $('#Loaderdiv').show();
                        $scope.tokenResponse = "";
                        $scope.user_infos = {
                            grant_type    : 'password',
                            client_id     : 2,
                            client_secret : 'mVTLXmHp9d3FBDzElhnyYwPYKlu3cGxJu8f8yH5L',
                            username      : $scope.emailModel,
                            password      : $scope.passwordMDL
                        };
                        var url = $scope.baseUrl+"/oauth/token";
                        $http({
                            method: 'POST',
                            url: url,
                            data: $.param($scope.user_infos),
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded"
                            }
                        }).then(function successCallback(response) {

                            if(response.status == 200 && response.data.access_token!=null) {
                                $scope.response_token = response.data;
                                var tokenResponse = $scope.response_token.token_type+' '+$scope.response_token.access_token;
                                checkAccess(tokenResponse);

                            } else {
                                $scope.tokenResponse = $scope.getErrorMessage(response);
                            }
                            $('#Loaderdiv').hide();
                            console.log('error success');

                        }, function errorCallback(response) {
                            $('#Loaderdiv').hide();
                            console.log('error callback');
                            $scope.tokenResponse = $scope.getErrorMessage(response);

                        });
                    };
                    // check access
                    function checkAccess(token) {
                        var url = $scope.baseUrl+"/api/admin/v1_0/checkAccess";
                        $http({
                            method: 'GET',
                            url: url,
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded",
                                "Authorization" : token
                            }
                        }).then(function successCallback(response) {
                            if(response.status == 200 && response.data=="") {
                                // Store token in coockie
                                $scope.putCoockie($scope.token, token);
                                window.location.replace(' /#/acceuil');
                                $('#Loaderdiv').hide();
                            } else {
                                $scope.tokenResponse = $scope.getErrorMessage(response);
                                $('#Loaderdiv').hide();
                            }

                        }, function errorCallback(response) {
                            $('#Loaderdiv').hide();
                            $scope.tokenResponse =  $scope.getErrorMessage(response);

                        });
                    }
                    // check changes
                    $scope.checkPswModel = function (val) {
                        $scope.passwordMDL  = val;
                    };
                    $scope.checkEmail  = function (val) {
                        $scope.emailModel  = val;
                    };
                }
            });
    }

})();