/**
 * Created by majid on 14/01/2017.
 */
(function () {
    'use strict';

    angular.module('BlurAdmin.pages.catalogue.variantes', [])
        .config(routeConfig);

    /** @ngInject */
    function routeConfig($stateProvider) {
        $stateProvider
            .state('catalogue.variantes', {
                url: '/variantes',
                templateUrl: 'app/pages/catalogue/variantes/variantes.html',
                title: 'Variantes',
                sidebarMeta: {
                    icon: 'ion-android-home',
                    order: 400,
                },
                controller: function($scope, $http, $stateParams, $state) {
                    if(!$scope.isLogged())
                        window.location.replace('/#/login');

                    $scope.variants          = [];
                    $scope.totalVariantes     = 0;
                    $scope.variantesPerPage   = 25;


                    $scope.pageChanged = function(newPage) {
                        getVariantes(newPage);
                    };

                    $('#Loaderdiv').show();
                    $('#divTable').hide();
                    $('#msgTop').hide();
                    $('#msgError').hide();

                    function getVariantes(pageNumber) {
                        console.log("pageNumber",pageNumber)
                        var url = $scope.url+"variants?pagination_per_page=25&page="+pageNumber;
                        $http({
                            method: 'GET',
                            url: url,
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {
                            $('#Loaderdiv').hide();
                            $('#divTable').show();
                            if(response.status == 200) {
                                $scope.variants = response.data.data;
                                $scope.totalVariantes = response.data.total;
                            } else {
                                $scope.error_response = $scope.getErrorMessage(response);
                                $('#divTable').hide();
                                $('#msgError').show();
                            }

                        }, function errorCallback(response) {
                            $scope.error_response = $scope.getErrorMessage(response);
                            $('#Loaderdiv').hide();
                            $('#divTable').hide();
                            $('#msgError').show();
                        });
                    }
                    getVariantes($scope.pagination.currentVariante);
                    // deactivate
                    $scope.deactivateVariant = function (id, val) {
                        $('#msgError').hide();
                        var url = $scope.url+"variants/"+id;
                        $scope.variant_data = {
                            deactivated          : $scope.booleanToInteger(val)
                        };
                        $http({
                            method: 'PUT',
                            url: url,
                            params : $scope.variant_data,
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {
                            $('#Loaderdiv').hide();
                            $('#divTable').show();
                            $('#msgTop').show();
                            if(response.status == 200){
                                $scope.detailVariants = response.data;
                                getVariantes($scope.pagination.current);
                            } else {
                                $scope.error_response = $scope.getErrorMessage(response);
                                $('#msgError').show();
                            }

                        }, function errorCallback(response) {
                            $scope.error_response = $scope.getErrorMessage(response);
                            $('#msgError').show();
                        });
                    }
                }
            }).state('consultationVariant', {
            url: '/consultationVariant',
            params: {id : null},
            templateUrl    : 'app/pages/catalogue/variantes/consultationVariant/consultationVariant.html',
            reloadOnSearch : true,
            title: 'Consultation Variantes',
            controller: function ($scope, $http, $stateParams, $state) {

                 if($stateParams.id != null)
                     $scope.putCoockie('parmsID', $stateParams.id);

                $('#Loaderdiv').show();
                $('#divTable').hide();
                $('#msgError').hide();
                function getVariantesById() {
                    var url = $scope.url+"variants/"+$scope.getCoockie('parmsID');
                    $http({
                        method: 'GET',
                        url: url,
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {
                        $('#Loaderdiv').hide();
                        $('#divTable').show();
                        if(response.status == 200){
                            $scope.detailVariant = response.data;
                            $('#divTable').show();
                            $('#msgError').hide();
                        } else {
                            $scope.error_response = $scope.getErrorMessage(response);
                            $('#divTable').hide();
                            $('#msgError').show();

                        }

                    }, function errorCallback(response) {
                        $scope.isShowLoader = false;
                        $scope.error_response = $scope.getErrorMessage(response);
                        $('#divTable').hide();
                        $('#msgError').show();
                        $('#Loaderdiv').hide();
                    });
                }

                getVariantesById();
            }

            }).state('addVariant', {
            url: '/addVariant',
            templateUrl    : 'app/pages/catalogue/variantes/addVariant/addVariant.html',
            reloadOnSearch : true,
            title: 'Ajouter Variantes',
            controller: function ($scope, $http, $stateParams, $state) {

                if(!$scope.isLogged())
                    window.location.replace('/#/login');

                $('#msgBottom').hide();
                $('#LoaderdivBottom').hide();

                $scope.addVariant = function () {
                    $('#msgBottom').hide();
                    $('#LoaderdivBottom').show();
                    var url = $scope.url+"variants";

                    $scope.variant_data = {
                        deactivated          : $scope.booleanToInteger($scope.deactivateMdl),
                        ERP_code             : $scope.codeMdl
                    };
                    if($scope.pictureMDL != null) {
                        var picParams = {picture             : $scope.pictureMDL.name.toString()};
                        $scope.variant_data = angular.extend({},$scope.variant_data, picParams)
                    }
                    $http({
                        method: 'POST',
                        url: url,
                        data :  $.param($scope.variant_data),
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {
                        $('#msgBottom').hide();
                        $('#LoaderdivBottom').hide();
                        if(response.status == 200){
                            $scope.detailVariant = response.data;
                            window.location.replace('/#/catalogue/variantes');
                        } else {

                            $scope.error_update_variant = $scope.getErrorMessage(response);
                        }
                        $('#msgBottom').show();
                        $('#LoaderdivBottom').hide();

                    }, function errorCallback(response) {
                        $('#msgBottom').show();
                        $('#LoaderdivBottom').hide();
                        $scope.error_update_variant = $scope.getErrorMessage(response);
                    });
                }

                $scope.checkCode = function(val) {
                    $scope.codeMdl = val ;
                }
                $scope.checkDeactivate = function(val) {
                    $scope.deactivateMdl = val ;
                }
                $scope.checkPic = function(val) {
                    $scope.pictureMDL = val ;
                }

            }
        }).state('updateVariant', {
            url: '/updateVariant',
            params: {id : null},
            templateUrl    : 'app/pages/catalogue/variantes/updateVariant/updateVariant.html',
            reloadOnSearch : true,
            title: 'Mise à jour Variantes',
            controller: function ($scope, $http, $stateParams, $state) {

                if(!$scope.isLogged())
                    window.location.replace('/#/login');

                if($stateParams.id != null)
                    $scope.putCoockie('parmsID', $stateParams.id);
                $('#Loaderdiv').show();
                $('#divTable').hide();
                $('#msgError').hide();
                $('#msgBottom').hide();
                $('#LoaderdivBottom').hide();

                function getVariantes() {
                    var url = $scope.url+"variants/"+$scope.getCoockie('parmsID');
                    $http({
                        method: 'GET',
                        url: url,
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {
                        $('#Loaderdiv').hide();
                        $('#divTable').show();
                        if(response.status == 200){
                            $('#divTable').show();
                            $('#msgError').hide();
                            $scope.detailVariants = response.data;
                            $scope.codeMdl        = $scope.detailVariants.ERP_code;
                            $scope.pictureMDL               = { name : $scope.detailVariants.picture};
                            $scope.previewImage             = "assets/pictures/"+$scope.detailVariants.picture;
                        } else {

                            $scope.error_response = $scope.getErrorMessage(response);
                            $('#divTable').hide();
                            $('#msgError').show();
                        }

                    }, function errorCallback(response) {
                        $('#Loaderdiv').hide();
                        $scope.error_response = $scope.getErrorMessage(response);
                        $('#divTable').hide();
                        $('#msgError').show();
                    });
                }
                getVariantes();

                $scope.updateVariant = function () {
                    $('#msgBottom').hide();
                    $('#LoaderdivBottom').show();
                    var url = $scope.url+"variants/"+$scope.getCoockie('parmsID');
                    $scope.variant_data = {
                        deactivated          : $scope.booleanToInteger($scope.deactivateMdl),
                        ERP_code             : $scope.codeMdl
                    };
                    if($scope.pictureMDL != null) {
                        var picParams = {picture             : $scope.pictureMDL.name.toString()};
                        $scope.variant_data = angular.extend({},$scope.variant_data, picParams)
                    }
                    $http({
                        method: 'PUT',
                        url: url,
                        data :  $.param($scope.variant_data),
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {
                        $('#Loaderdiv').hide();
                        $('#divTable').show();
                        $('#msgBottom').hide();
                        $('#LoaderdivBottom').hide();
                        if(response.status == 200){
                            $scope.detailVariants = response.data;
                            window.location.replace('/#/catalogue/variantes');
                        } else
                            $scope.response_error = "Une erreur s'est produite, merci de réessayer.";

                    }, function errorCallback(response) {
                        $('#Loaderdiv').hide();
                        $('#divTable').show();
                        $('#msgBottom').show();
                        $('#LoaderdivBottom').hide();
                        $scope.error_update_variant = $scope.getErrorMessage(response);
                    });
                }

                $scope.checkCode = function(val) {
                    $scope.codeMdl = val ;
                }
                $scope.checkDeactivate = function(val) {
                    $scope.deactivateMdl = val ;
                }
                $scope.checkPic = function(val) {
                    $scope.pictureMDL = val ;
                }
            }

        });
    }

})();