/**
 * Created by majid on 14/01/2017.
 */
(function () {
    'use strict';

    angular.module('BlurAdmin.pages.catalogue.produits', [])
        .config(routeConfig);

    /** @ngInject */
    function routeConfig($stateProvider) {
        $stateProvider
            .state('catalogue.produits', {
                url: '/produits',
                templateUrl: 'app/pages/catalogue/produits/produits.html',
                title: 'Produits',
                sidebarMeta: {
                    icon: 'ion-android-home',
                    order: 300,
                },
                controller: function ($scope, $stateParams, $http, $state) {
                    if(!$scope.isLogged())
                        window.location.replace('/#/login');

                    $('#Loaderdiv').hide();
                    $('#divTable').hide();
                    $('#divEmpty').hide();
                    $('#msgError').hide();
                    $scope.products = [];
                    $scope.totalProducts = 0;
                    $scope.productsPerPage = 25;
                    $scope.strMdlBox = true;
                    $scope.nonStrMdlBox = true;
                    $scope.gabarit = {isGabaritMdlBox :  true, isNonGabaritMdlBox :  true};
                    $scope.searchCommand = function (pageNumber) {
                        $('#Loaderdiv').show();
                        $('#divTable').hide();
                        $('#divEmpty').hide();
                        $('#msgError').hide();
                        var url = $scope.url+"products?pagination_per_page=25&page="+pageNumber;
                        $http({
                            method: 'GET',
                            url: url,
                            params : getParamsSearch(),
                            headers: {
                                "Content-Type": "application/json;charset=UTF-8",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {
                            $('#Loaderdiv').hide();
                            $('#divTable').show();
                            if(response.status == 200) {
                                $scope.products = response.data.data;
                                $scope.totalProducts = response.data.total;
                                if($scope.products.length < 1){
                                    $('#divTable').hide();
                                    $('#divEmpty').show();
                                    $('#msgError').hide();
                                } else {
                                    $('#divTable').show();
                                    $('#divEmpty').hide();
                                    $('#msgError').hide();
                                }

                            } else {
                                $scope.error_response = $scope.getErrorMessage(response);
                                $('#divTable').hide();
                                $('#msgError').show();
                            }

                        }, function errorCallback(response) {
                            $scope.products ={};
                            $scope.error_response = $scope.getErrorMessage(response);
                            $('#Loaderdiv').hide();
                            $('#divTable').hide();
                            $('#msgError').show();

                        });
                    }


                    $scope.pageChanged = function(newPage) {
                        getProducts(newPage);
                    };
                    function getGroups() {
                        var url = $scope.url+"groups";
                        $http({
                            method: 'GET',
                            url: url,
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {

                            if(response.status == 200) {
                                $scope.groups = response.data;
                            } else
                                $scope.response_error = "Une erreur s'est produite, merci de réessayer.";
                            $('#Loaderdiv').hide();
                            $('#divParent').show();

                        }, function errorCallback(response) {
                            $scope.response_error = response.data.message;
                            $('#Loaderdiv').hide();
                            $('#divParent').show();
                        });
                    }
                    getGroups();
                    function getClients() {
                        var url = $scope.url+"clients";
                        $http({
                            method: 'GET',
                            url: url,
                            headers: {
                                "Content-Type": "application/json;charset=UTF-8",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {

                            if(response.status == 200) {
                                $scope.clients = response.data;
                            }

                        }, function errorCallback(response) {

                        });
                    }
                    getClients();
                    // Get products
                    function getProducts(pageNumber) {
                        var url = $scope.url+"products?pagination_per_page=25&page="+pageNumber;
                        $http({
                            method: 'GET',
                            url: url,
                            params : getParamsSearch(),
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {
                            $('#Loaderdiv').hide();
                            if(response.status == 200) {
                                $('#divProduct').show();
                                $scope.products = response.data.data;
                                $scope.totalProducts = response.data.total;
                            }else {
                                $scope.error_response = $scope.getErrorMessage(response);
                                $('#divProduct').hide();
                                $('#msgError').show();
                            }

                        }, function errorCallback(response) {
                            $('#Loaderdiv').hide();
                            $scope.error_response = $scope.getErrorMessage(response);
                            $('#divProduct').hide();
                            $('#msgError').show();
                        });
                    }
                    //getProducts($scope.pagination.currentProduct);
                    $scope.deactivateProduit = function (id, val) {
                        $('#msgError').hide();
                        var datas = {
                            deactivated : val
                        };
                        var url = $scope.url+"products/"+id;
                        $http({
                            method: 'PUT',
                            params : datas,
                            url: url,
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {
                            $('#Loaderdiv').hide();
                            if(response.status == 200){
                                $('#msgTop').show();
                                getProducts($scope.pagination.current);
                            } else {
                                $scope.error_response = $scope.getErrorMessage(response);
                                $('#msgError').show();
                            }

                        }, function errorCallback(response) {
                            $('#Loaderdiv').hide();
                            $scope.error_response = $scope.getErrorMessage(response);
                            $('#msgError').show();

                        });
                    }
                    function getParamsSearch() {

                        var paramsSearch = {};

                        var name          = {name           : $scope.nameMdl};
                        var sousFamille    = {group_id      : $scope.sousFamilleModel};
                        var codeClient    = {specific_client_id      : $scope.codeClientMdl};
                        var nonStandard   = null;
                        var isGabarit     = null;

                        if ($scope.strMdlBox == true && $scope.nonStrMdlBox == true) {
                            nonStandard = null;
                        }
                        else if ($scope.strMdlBox == false && $scope.nonStrMdlBox == false) {
                            nonStandard = {non_standard: 2};
                        }
                        else if ($scope.strMdlBox == false) {
                            nonStandard = {non_standard: $scope.booleanToInteger($scope.nonStrMdlBox)};
                        }
                        else if ($scope.nonStrMdlBox == false) {
                            nonStandard         = {non_standard : $scope.booleanToInteger(!$scope.strMdlBox)};
                        }

                        if ($scope.gabarit.isNonGabaritMdlBox == true && $scope.gabarit.isGabaritMdlBox == true) {
                            isGabarit = null;
                        }
                        else if ($scope.nonStrMdlBox == false) {
                            isGabarit = null;
                        }
                        else if ($scope.gabarit.isNonGabaritMdlBox == false && $scope.gabarit.isGabaritMdlBox == false) {
                            isGabarit = {is_gabarit : 2};
                        }
                        else if ($scope.gabarit.isGabaritMdlBox == false) {
                            isGabarit = {is_gabarit: $scope.gabarit.isNonGabaritMdlBox ? 0 : 1};
                        }
                        else if ($scope.gabarit.isNonGabaritMdlBox == false) {
                            isGabarit = {is_gabarit: $scope.gabarit.isGabaritMdlBox ? 1 : 0};
                        }

                        if(!$scope.sousFamilleModelCheckbox)
                            paramsSearch = angular.extend({},paramsSearch, sousFamille)


                        if(!$scope.nameMdlBox)
                            paramsSearch = angular.extend({},paramsSearch, name)
                        if(!$scope.codeClientMdlBox)
                            paramsSearch = angular.extend({},paramsSearch, codeClient)
                        if (nonStandard != null) {
                            paramsSearch = angular.extend({}, paramsSearch, nonStandard)
                        }
                        if (isGabarit != null)
                            paramsSearch = angular.extend({},paramsSearch, isGabarit)

                        return paramsSearch;
                    }
                    $scope.checkName = function (val) {
                        $scope.nameMdl = val;
                    };
                    $scope.checkNameBox = function (val) {
                        $scope.nameMdlBox = val;
                        if($scope.nameMdlBox==true) $('#nameMdl1').val("");
                    };
                    $scope.checksousFamille = function (val) {
                        $scope.sousFamilleModel = val;
                    };
                    $scope.checksousFamilleBox = function (val) {
                        $scope.sousFamilleModelCheckbox = val;
                        if($scope.sousFamilleModelCheckbox==true) $('#sousFamilleModel').val("");
                    };
                    $scope.checkCodeClient = function (val) {
                        $scope.codeClientMdl = val;
                    };

                    $scope.checkCodeClientBox = function (val) {
                        $scope.codeClientMdlBox = val;
                        if($scope.codeClientMdlBox==true) $('#codeClientMdl').val("");
                    };
                    $scope.checkStrBox = function (val) {
                        $scope.strMdlBox = val;
                    };
                    $scope.checkNonStrBox = function (val) {
                        $scope.nonStrMdlBox = val;
                        if ($scope.nonStrMdlBox == false) {
                            $scope.gabarit.isNonGabaritMdlBox = false;
                            $scope.gabarit.isGabaritMdlBox = false;
                        }
                        else {
                            $scope.gabarit.isNonGabaritMdlBox = true;
                            $scope.gabarit.isGabaritMdlBox = true;
                        }
                    };
                    $scope.checkIsNonGabaritBox = function (val) {
                        $scope.gabarit.isNonGabaritMdlBox = val;
                    };
                    $scope.checkIsGabaritBox = function (val) {
                        $scope.gabarit.isGabaritMdlBox = val;
                    };
                }

            }).state('consultationProduct', {
            url: '/consultationProduct',
            params: {id : null},
            templateUrl: 'app/pages/catalogue/produits/consultationProduct/consultationProduct.html',
            controller: function ($scope, $stateParams, $http, $state) {
                if (!$scope.isLogged())
                    window.location.replace('/#/login');
                $('#msgError').hide();
                $('#divBody').hide();

                if($stateParams.id != null)
                    $scope.putCoockie('parmsID', $stateParams.id);
                // Get
                function getCategory(id) {
                    var url = $scope.url+"categories/"+id;
                    $http({
                        method: 'GET',
                        url: url,
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {

                        if(response.status == 200) {
                            $scope.category = response.data;
                        } else
                            $scope.response_error = "Une erreur s'est produite, merci de réessayer.";

                    }, function errorCallback(response) {
                        $scope.response_error = response.data.message;
                    });
                }
                function getProduit() {
                    var url = $scope.url+"products/"+$scope.getCoockie('parmsID');
                    $http({
                        method: 'GET',
                        url: url,
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {
                        if(response.status == 200){
                            $('#msgError').hide();
                            $('#divBody').show();

                            $scope.produit = response.data;
                            var id = $scope.produit.group.category_id;
                            getCategory(id);
                            $scope.clientMdl= $scope.produit.specific_client_id;
                            $scope.priceAttr1 = $scope.produit.price_attr1;
                            $scope.priceAttr2 = $scope.produit.price_attr2;
                            $scope.priceAttr3 = $scope.produit.price_attr3;
                        } else {
                            $scope.error_response = $scope.getErrorMessage(response);
                            $('#msgError').show();
                            $('#divBody').hide();
                        }


                    }, function errorCallback(response) {
                        $scope.error_response = $scope.getErrorMessage(response);
                        $('#msgError').show();
                        $('#divBody').hide();
                    });
                }

                getProduit();
                getClients();
                getDimensions();

                function getClients() {
                    var url = $scope.url+"clients";
                    $http({
                        method: 'GET',
                        url: url,
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {
                        if(response.status == 200) {
                            $scope.clients = response.data;
                            //$scope.clientMdl = $scope.clients[0].id ;
                        } else
                            $scope.response_error = "Une erreur s'est produite, merci de réessayer.";

                    }, function errorCallback(response) {

                        $scope.response_error = response.data.message;
                    });
                }

                // Get dimensions
                function getDimensions() {
                    var url = $scope.url+"dimensions";
                    $http({
                        method: 'GET',
                        url: url,
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {
                        if(response.status == 200) {
                            $scope.dimensions = response.data;
                        } else
                            $scope.response_error = "Une erreur s'est produite, merci de réessayer.";

                    }, function errorCallback(response) {

                        $scope.response_error = response.data.message;
                    });
                }

            }
            }).state('addProduct', {
                url: '/addProduct',
                templateUrl: 'app/pages/catalogue/produits/addProduct/addProduct.html',
                controller: function ($scope, $stateParams, $http, $state) {
                    if(!$scope.isLogged())
                        window.location.replace('/#/login');

                    $('#Loaderdiv').show();
                    $('#divParent').hide();
                    $('#msgBottom').hide();
                    $('#LoaderdivBottom').hide();

                    $scope.productDetail = {deactivated: 0, visible_individual: 0, non_standard: 0, is_gabarit: 0};

                    $scope.selectVariants = [];
                    // add row
                    $scope.references = [];

                    $scope.longueurMDL = 0;
                    $scope.largeurMDL = 0;
                    $scope.hauteurMDL = 0;
                    $scope.dimSupp1MDL = 0;
                    $scope.dimSupp2MDL = 0;
                    $scope.dimSupp3MDL = 0;
                    $scope.dimSupp4MDL = 0;
                    $scope.dimSupp5MDL = 0;
                    $scope.infoSupp1MDL = 0;
                    $scope.infoSupp2MDL = 0;

                    $scope.priceAttr1 = '';
                    $scope.priceAttr2 = '';
                    $scope.priceAttr3 = '';

                    // add row
                    $scope.addItem = function () {
                        $scope.references.push(
                            {
                                client_id : null,
                                client_name : null,
                                visible : true
                            })
                    };
                    // remove row
                    $scope.removeReference = function (item) {
                        var index = $scope.references.indexOf(item);
                        $scope.references[index].visible = false;
                        $scope.references[index].client_name = "aaaaa";
                        //$scope.references.splice(index, 1);
                    }
                    // Get variants
                    function getVariants() {
                        var url = $scope.url+"variants";
                        $http({
                            method: 'GET',
                            url: url,
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {
                            if(response.status == 200) {
                                $scope.variants = response.data;
                                for(var i =0;i < $scope.variants.length; i++) {
                                    $scope.selectVariants.push({
                                        id          : $scope.variants[i].id,
                                        ERP_code    : $scope.variants[i].ERP_code,
                                        deactivated : $scope.variants[i].deactivated,
                                        isChecked   : null
                                    });
                                }
                            }  else
                                $scope.response_error = "Une erreur s'est produite, merci de réessayer.";

                        }, function errorCallback(response) {

                            $scope.response_error = response.data.message;
                        });
                    }

                    // Get unit
                    function getUnits() {
                        var url = $scope.url+"units";
                        $http({
                            method: 'GET',
                            url: url,
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {
                            if(response.status == 200) {
                                $scope.units = response.data;
                                $scope.unitMdl =  $scope.units[0].id ;
                            } else
                                $scope.response_error = "Une erreur s'est produite, merci de réessayer.";

                        }, function errorCallback(response) {

                            $scope.response_error = response.data.message;
                        });
                    }
                    // Get client
                    function getClients() {
                        var url = $scope.url+"clients";
                        $http({
                            method: 'GET',
                            url: url,
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {
                            if(response.status == 200) {
                                $scope.clients = response.data;
                            } else
                                $scope.response_error = "Une erreur s'est produite, merci de réessayer.";

                        }, function errorCallback(response) {

                            $scope.response_error = response.data.message;
                        });
                    }

                    // Get categories
                    function getCategories() {
                        var url = $scope.url+"categories";
                        $http({
                            method: 'GET',
                            url: url,
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {

                            if(response.status == 200) {
                                $scope.categories = response.data;
                                $scope.catMdl = $scope.categories[0].id;
                                getGroups($scope.catMdl);

                            } else
                                $scope.response_error = "Une erreur s'est produite, merci de réessayer.";
                            $('#Loaderdiv').hide();
                            $('#divParent').show();

                        }, function errorCallback(response) {
                            $scope.response_error = response.data.message;
                            $('#Loaderdiv').hide();
                            $('#divParent').show();
                        });
                    }
                    // Get groups
                    function getGroups(id) {
                        var url = $scope.url+"categories/"+id;
                        $http({
                            method: 'GET',
                            url: url,
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {
                            if(response.status == 200) {
                                $scope.groups = response.data.groups;
                                $scope.groupMdl = $scope.groups[0].id;
                            } else
                                $scope.response_error = "Une erreur s'est produite, merci de réessayer.";

                        }, function errorCallback(response) {

                            $scope.response_error = response.data.message;
                        });
                    }
                   // Get remises
                    function getRemises() {
                        var url = $scope.url+"discounts";
                        $http({
                            method: 'GET',
                            url: url,
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {
                            if(response.status == 200) {
                                $scope.remises = response.data;
                                $scope.remiseMdl = 0;
                            } else
                                $scope.response_error = "Une erreur s'est produite, merci de réessayer.";

                        }, function errorCallback(response) {

                            $scope.response_error = response.data.message;
                        });
                    }
                    // Get remises
                    function getRate() {
                        var url = $scope.url+"vats";
                        $http({
                            method: 'GET',
                            url: url,
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {
                            if(response.status == 200) {
                                $scope.rates = response.data;
                                $scope.rateMdl = $scope.rates[0].id;
                            } else
                                $scope.response_error = "Une erreur s'est produite, merci de réessayer.";

                        }, function errorCallback(response) {

                            $scope.response_error = response.data.message;
                        });
                    }

                    // Get dimensions
                    function getDimensions() {
                        var url = $scope.url+"dimensions";
                        $http({
                            method: 'GET',
                            url: url,
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {
                            if(response.status == 200) {
                                $scope.dimensions = response.data;
                            } else
                                $scope.response_error = "Une erreur s'est produite, merci de réessayer.";

                        }, function errorCallback(response) {

                            $scope.response_error = response.data.message;
                        });
                    }

                    function getProductParams() {
                        var paramsProduct = {};
                        var deactivateProduct           = {deactivated                     : $scope.productDetail.deactivated};
                        var visibleProduct              = {visible_individual              : $scope.productDetail.visible_individual};
                        var horsStandardProduct         = {non_standard                    : $scope.productDetail.non_standard};
                        var isGabaritProduct            = {is_gabarit                      : $scope.productDetail.is_gabarit};
                        var saisir_longueur              ={saisir_longueur                    : $scope.booleanToInteger($scope.longueurMDL)};
                        var saisir_largeur              ={saisir_largeur                    : $scope.booleanToInteger($scope.largeurMDL)};
                        var saisir_hauteur              ={saisir_hauteur                    : $scope.booleanToInteger($scope.hauteurMDL)};
                        var saisir_dim_supp_1             ={saisir_dim_supp_1                    : $scope.booleanToInteger($scope.dimSupp1MDL)};
                        var saisir_dim_supp_2             ={saisir_dim_supp_2                   : $scope.booleanToInteger($scope.dimSupp2MDL)};
                        var saisir_dim_supp_3            ={saisir_dim_supp_3                   : $scope.booleanToInteger($scope.dimSupp3MDL)};
                        var saisir_dim_supp_4           ={saisir_dim_supp_4                   : $scope.booleanToInteger($scope.dimSupp4MDL)};
                        var saisir_dim_supp_5            ={saisir_dim_supp_5                   : $scope.booleanToInteger($scope.dimSupp5MDL)};
                        var saisir_info_supp_1            ={saisir_info_supp_1                   : $scope.booleanToInteger($scope.infoSupp1MDL)};
                        var saisir_info_supp_2            ={saisir_info_supp_2                   : $scope.booleanToInteger($scope.infoSupp2MDL)};
                        var label_dim_supp_1             ={label_dim_supp_1                  :$scope.ds1Mdl};
                        var label_dim_supp_2            ={label_dim_supp_2                   : $scope.ds2Mdl};
                        var label_dim_supp_3            ={label_dim_supp_3                   : $scope.ds3Mdl};
                        var label_dim_supp_4            ={label_dim_supp_4                  : $scope.ds4Mdl};
                        var label_dim_supp_5           ={label_dim_supp_5                  : $scope.ds5Mdl};
                        var label_info_supp_1           ={label_info_supp_1                  : $scope.info1Mdl};
                        var label_info_supp_2           ={label_info_supp_2                  : $scope.info2Mdl};

                        var groupProduct                = {group_id                        : $scope.groupMdl};
                        var nameProduct                 = {name                            : $scope.namePrModel};
                        var codeProduct                 = {ERP_code                        : $scope.codeModel};
                        var unitProduct                 = {unit_id                         : $scope.unitMdl};
                        var lengthProduct               = {length                          : parseFloat($scope.lngMdl)};
                        var widthProduct                = {width                           : parseFloat($scope.lrgMdl)};
                        var highProduct                 = {high                            : parseFloat($scope.htMdl)};
                        var priceTTCProduct             = {price_ttc                       : $scope.convertToPriceFormat($scope.priceMdl)};
                        var vatProduct                  = {vat_id                          : $scope.rateMdl};
                        var discountProduct             = {discount_id                     : $scope.remiseMdl};
                        var clientProduct               = {specific_client_id              : $scope.clientMdl};
                        var externalReferencesProduct   = {external_references             : $scope.referencesExt};
                        var variantsProduct             = {variants                        : $scope.variantsChekced};
                        var price_attr1                 = {price_attr1                     : $scope.priceAttr1};
                        var price_attr2                 = {price_attr2                     : $scope.priceAttr2};
                        var price_attr3                 = {price_attr3                     : $scope.priceAttr3};

                        paramsProduct = angular.extend({},paramsProduct, deactivateProduct)
                        paramsProduct = angular.extend({},paramsProduct, visibleProduct)
                        paramsProduct = angular.extend({},paramsProduct, horsStandardProduct)
                        paramsProduct = angular.extend({},paramsProduct, isGabaritProduct)
                        paramsProduct = angular.extend({},paramsProduct, saisir_longueur )
                        paramsProduct = angular.extend({},paramsProduct, saisir_largeur )
                        paramsProduct = angular.extend({},paramsProduct, saisir_hauteur )
                        paramsProduct = angular.extend({},paramsProduct, saisir_dim_supp_1)
                        paramsProduct = angular.extend({},paramsProduct, saisir_dim_supp_2)
                        paramsProduct = angular.extend({},paramsProduct, saisir_dim_supp_3)
                        paramsProduct = angular.extend({},paramsProduct, saisir_dim_supp_4)
                        paramsProduct = angular.extend({},paramsProduct, saisir_dim_supp_5)
                        paramsProduct = angular.extend({},paramsProduct, saisir_info_supp_1)
                        paramsProduct = angular.extend({},paramsProduct, saisir_info_supp_2)
                        if($scope.groupMdl != null)
                            paramsProduct = angular.extend({},paramsProduct, groupProduct)
                        if($scope.namePrModel != null)
                            paramsProduct = angular.extend({},paramsProduct, nameProduct)
                        if($scope.codeModel != null)
                            paramsProduct = angular.extend({},paramsProduct, codeProduct)
                        if($scope.unitMdl != null)
                            paramsProduct = angular.extend({},paramsProduct, unitProduct)
                        if($scope.lngMdl!= null)
                            paramsProduct = angular.extend({},paramsProduct, lengthProduct)
                        if($scope.lrgMdl != null)
                            paramsProduct = angular.extend({},paramsProduct, widthProduct)
                        if($scope.htMdl != null)
                            paramsProduct = angular.extend({},paramsProduct, highProduct)
                        if($scope.priceMdl != null)
                            paramsProduct = angular.extend({},paramsProduct, priceTTCProduct)
                        if($scope.rateMdl != null)
                            paramsProduct = angular.extend({},paramsProduct, vatProduct)
                        if($scope.remiseMdl > 0)
                            paramsProduct = angular.extend({},paramsProduct, discountProduct)
                        if($scope.clientMdl != null && $scope.clientMdl > 0)
                            paramsProduct = angular.extend({},paramsProduct, clientProduct)
                        if($scope.variantsChekced.length > 0)
                            paramsProduct = angular.extend({},paramsProduct, variantsProduct)
                        if($scope.referencesExt.length > 0)
                            paramsProduct = angular.extend({},paramsProduct, externalReferencesProduct)
                        if($scope.ds1Mdl != null)
                            paramsProduct = angular.extend({},paramsProduct, label_dim_supp_1)
                        if($scope.ds2Mdl != null)
                            paramsProduct = angular.extend({},paramsProduct, label_dim_supp_2)
                        if($scope.ds3Mdl != null)
                            paramsProduct = angular.extend({},paramsProduct, label_dim_supp_3)
                        if($scope.ds4Mdl != null)
                            paramsProduct = angular.extend({},paramsProduct, label_dim_supp_4)
                        if($scope.ds5Mdl != null)
                            paramsProduct = angular.extend({},paramsProduct, label_dim_supp_5)
                        if($scope.ds5Mdl != null)
                            paramsProduct = angular.extend({},paramsProduct, label_dim_supp_5)
                        if($scope.info1Mdl != null)
                            paramsProduct = angular.extend({},paramsProduct, label_info_supp_1)
                        if($scope.info2Mdl != null)
                            paramsProduct = angular.extend({},paramsProduct, label_info_supp_2)
                        if ($scope.priceAttr1)
                            paramsProduct = angular.extend({},paramsProduct, price_attr1)
                        if ($scope.priceAttr2)
                            paramsProduct = angular.extend({},paramsProduct, price_attr2)
                        if ($scope.priceAttr3)
                            paramsProduct = angular.extend({},paramsProduct, price_attr3)

                        return paramsProduct;
                    }
                    $scope.variantsChekced = [];
                    // prepare varaiants
                     function prepareVariants() {
                         for(var i =0;i < $scope.selectVariants.length; i++) {
                             if( $scope.selectVariants[i].isChecked != null &&  $scope.selectVariants[i].isChecked){
                                 $scope.variantsChekced.push({
                                     variant_id       : $scope.selectVariants[i].id
                                 });
                             }
                         }
                     }
                    $scope.addProduit = function () {
                        $('#msgBottom').hide();
                        $('#LoaderdivBottom').show();

                        prepareVariants();
                        //if($scope.variantsChekced.length > 0) {
                            prepareReferences();
                            var url = $scope.url + "products";
                            $http({
                                method: 'POST',
                                url: url,
                                data: JSON.stringify(getProductParams()),
                                headers: {
                                    "Content-Type": "application/json",
                                    "Authorization": $scope.userSession()
                                }
                            }).then(function successCallback(response) {
                                if (response.status == 200) {
                                    window.location.replace('/#/catalogue/produits');
                                } else
                                    $scope.error_add_produit = $scope.getErrorMessage(response);
                                $('#msgBottom').hide();
                                $('#LoaderdivBottom').hide();
                            }, function errorCallback(response) {
                                $scope.error_add_produit = $scope.getErrorMessage(response);
                                $('#msgBottom').show();
                                $('#LoaderdivBottom').hide();
                            });
                        }
                    //else {
                      //      $('#msgBottom').show();
                        //    $('#LoaderdivBottom').hide();
                          //  $scope.error_add_produit = "Merci d'ajouter au moins une variante à ce produit";
                        //}
                    //}
                    // prepare external references
                    function prepareReferences() {
                        $scope.referencesExt = [];
                        for (var i = 0; i<$scope.references.length; i++){
                            if($scope.references[i].visible)
                             $scope.referencesExt.push({client_id : $scope.references[i].client_id,reference_name : $scope.references[i].client_name})
                        }
                    }
                    getVariants();
                    getUnits();
                    getClients();
                    getCategories();
                    getRemises();
                    getRate();
                    getDimensions();

                    $scope.checkDeactivate = function() {
                        if ($scope.productDetail.deactivated == 0)
                            $scope.productDetail.deactivated = 1;
                        else
                            $scope.productDetail.deactivated = 0;
                    }
                    $scope.checkVisible = function() {
                        if ($scope.productDetail.visible_individual == 0)
                            $scope.productDetail.visible_individual = 1;
                        else
                            $scope.productDetail.visible_individual = 0;
                    }
                    $scope.checkHorsStandard = function() {
                        if ($scope.productDetail.non_standard == 0)
                            $scope.productDetail.non_standard = 1;
                        else {
                            $scope.productDetail.non_standard = 0;
                            $scope.productDetail.is_gabarit = 0;
                        }
                    }
                    $scope.checkIsGabarit = function() {
                        if ($scope.productDetail.is_gabarit == 0)
                            $scope.productDetail.is_gabarit = 1;
                        else
                            $scope.productDetail.is_gabarit = 0;
                    }
                    $scope.checkCode = function(val) {
                        $scope.codeModel = val ;
                    }
                    $scope.checkUnit = function(val) {
                        $scope.unitMdl = val ;
                    }
                    $scope.checkLng = function(val) {
                        $scope.lngMdl = val ;
                    }
                    $scope.checkLrg = function(val) {
                        $scope.lrgMdl = val ;
                    }
                    $scope.checkHt = function(val) {
                        $scope.htMdl = val ;
                    }
                    $scope.checkNamePr = function(val) {
                        $scope.namePrModel = val ;
                    }
                    $scope.checkPic = function(val) {
                        $scope.picMdl = val ;
                    }

                    $scope.checkClient = function(val) {
                        $scope.clientMdl = val ;
                    }
                    $scope.checkCategory = function(val) {
                        $scope.catMdl = val ;
                        getGroups($scope.catMdl);

                    }

                    $scope.checkGroup = function(val) {
                        $scope.groupMdl = val ;
                    }
                    $scope.checkRemise = function(val) {
                        $scope.remiseMdl = val ;
                    }
                    $scope.checkRate = function(val) {
                        $scope.rateMdl = val ;
                    }

                    $scope.checkPrice = function(val) {
                        $scope.priceMdl = val ;
                    }
                    $scope.checklgt = function(val) {
                        if(val==true){
                            $('#lngMdl').val("");
                            $scope.lngMdl=null;
                        }
                        $scope.longueurMDL = val ;
                    }
                    $scope.checklarg = function(val) {
                        if(val==true){
                            $('#lrgMdl').val("");
                            $scope.lrgMdl=null;
                        }
                        $scope.largeurMDL = val ;
                    }
                    $scope.checkhat = function(val) {
                        if(val==true){
                            $('#htMdl').val("");
                            $scope.htMdl=null;
                        }
                        $scope.hauteurMDL = val ;
                    }
                    $scope.checkDs1 = function(val) {

                        $scope.ds1Mdl = val ;
                    }

                    $scope.checkDs2 = function(val) {

                        $scope.ds2Mdl = val ;
                    }
                    $scope.checkDs3 = function(val) {

                        $scope.ds3Mdl = val ;
                    }
                    $scope.checkDs4 = function(val) {
                        $scope.ds4Mdl = val ;
                    }
                    $scope.checkDs5 = function(val) {
                        $scope.ds5Mdl = val ;
                    }
                    $scope.checkinfo1 = function(val) {
                        $scope.info1Mdl = val ;
                    }
                    $scope.checkinfo2 = function(val) {
                        $scope.info2Mdl = val ;
                    }
                    $scope.checkInfo1 = function(val) {
                        if(val==false){
                            $('#info1Mdl').val("");
                            $scope.info1Mdl=null;
                        }
                        $scope.infoSupp1MDL = val ;
                    }
                    $scope.checkInfo2 = function(val) {
                        if(val==false){
                            $('#info2Mdl').val("");
                            $scope.info2Mdl=null;
                        }
                        $scope.infoSupp2MDL = val ;
                    }
                    $scope.checkDim3 = function(val) {
                        if(val==false){
                            $('#ds3Mdl').val("");
                            $scope.ds3Mdl=null;
                        }
                        $scope.dimSupp3MDL = val ;
                    }
                    $scope.checkDim1 = function(val) {
                        if(val==false){
                            $('#ds1Mdl').val("");
                            $scope.ds1Mdl=null;
                        }
                        $scope.dimSupp1MDL = val ;
                    }
                    $scope.checkDim2 = function(val) {
                        if(val==false){
                            $('#ds2Mdl').val("");
                            $scope.ds2Mdl=null;
                        }
                        $scope.dimSupp2MDL = val ;
                    }
                    $scope.checkDim4 = function(val) {
                        if(val==false){
                            $('#ds4Mdl').val("");
                        }
                        $scope.dimSupp4MDL = val ;
                    }
                    $scope.checkDim5 = function(val) {
                        if(val==false){
                            $('#ds5Mdl').val("");
                        }
                        $scope.dimSupp5MDL = val ;
                    }
                    $scope.checkPriceAttr1 = function(val) {
                        $scope.priceAttr1 = val != '' ? val : null;
                    }
                    $scope.checkPriceAttr2 = function(val) {
                        $scope.priceAttr2 = val != '' ? val : null;
                    }
                    $scope.checkPriceAttr3 = function(val) {
                        $scope.priceAttr3 = val != '' ? val : null;
                    }
                }
        }).state('updateProduct', {
            url: '/updateProduct',
            params: {id : null},
            templateUrl: 'app/pages/catalogue/produits/updateProduct/updateProduct.html',
            controller: function ($scope, $stateParams, $http, $state) {
                if(!$scope.isLogged())
                    window.location.replace('/#/login');

                if($stateParams.id != null)
                    $scope.putCoockie('parmsID', $stateParams.id);

                $('#Loaderdiv').show();
                $('#msgError').hide();
                $('#divBody').hide();
                $('#msgBottom').hide();
                $('#LoaderdivBottom').hide();

                $scope.selectVariants = [];
                // add row
                $scope.references = [];

                // add row
                $scope.addItem = function () {

                    $scope.references.push(
                        {
                            client_id : null,
                            client_name : null,
                            visible : true
                        })
                };
                // remove row
                $scope.removeReference = function (item) {
                    var index = $scope.references.indexOf(item);
                    $scope.references[index].visible = false;
                    $scope.references[index].client_name = "aaaaa";
                    //$scope.references.splice(index, 1);
                }
                // Get products
                function getProduct() {
                    var url = $scope.url+"products/"+$scope.getCoockie('parmsID');
                    $http({
                        method: 'GET',
                        url: url,
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {
                        $('#Loaderdiv').hide();
                        if(response.status == 200) {
                            $scope.productDetail = response.data;
                            // init fields
                            if($scope.productDetail.length==0.00){
                                $scope.productDetail.length=null;
                            }
                            if($scope.productDetail.width==0.00){
                                $scope.productDetail.width=null;
                            }
                            if($scope.productDetail.high==0.00){
                                $scope.productDetail.high=null;
                            }

                            $scope.unitMdl      = $scope.productDetail.unit_id;
                            $scope.catMdl       = $scope.productDetail.group.category_id;
                            $scope.remiseMdl    = $scope.productDetail.discount_id;
                            $scope.rateMdl      = $scope.productDetail.vat_id;
                            $scope.ds1Mdl       = $scope.productDetail.label_dim_supp_1;
                            $scope.ds2Mdl       = $scope.productDetail.label_dim_supp_2;
                            $scope.ds3Mdl       = $scope.productDetail.label_dim_supp_3;
                            $scope.ds4Mdl       = $scope.productDetail.label_dim_supp_4;
                            $scope.ds5Mdl       = $scope.productDetail.label_dim_supp_5;
                            $scope.info1Mdl       = $scope.productDetail.label_info_supp_1;
                            $scope.info2Mdl       = $scope.productDetail.label_info_supp_2;
                            $scope.longueurMDL  =$scope.integerToBoolean($scope.productDetail.saisir_longueur);
                            $scope.largeurMDL  =$scope.integerToBoolean($scope.productDetail.saisir_largeur);
                            $scope.hauteurMDL  =$scope.integerToBoolean($scope.productDetail.saisir_hauteur);
                            $scope.dimSupp1MDL=$scope.integerToBoolean($scope.productDetail.saisir_dim_supp_1);
                            $scope.dimSupp2MDL=$scope.integerToBoolean($scope.productDetail.saisir_dim_supp_2);
                            $scope.dimSupp3MDL=$scope.integerToBoolean($scope.productDetail.saisir_dim_supp_3);
                            $scope.dimSupp4MDL=$scope.integerToBoolean($scope.productDetail.saisir_dim_supp_4);
                            $scope.dimSupp5MDL=$scope.integerToBoolean($scope.productDetail.saisir_dim_supp_5);
                            $scope.infoSupp1MDL=$scope.integerToBoolean($scope.productDetail.saisir_info_supp_1);
                            $scope.infoSupp1MDL=$scope.integerToBoolean($scope.productDetail.saisir_info_supp_2);

                            getGroups($scope.catMdl, $scope.productDetail.group_id);
                            $scope.codeModel    = $scope.productDetail.ERP_code;
                            $scope.clientMdl=$scope.productDetail.specific_client_id;
                            $scope.lngMdl       = parseFloat($scope.productDetail.length);
                            $scope.lrgMdl       = parseFloat($scope.productDetail.width);
                            $scope.htMdl        = parseFloat($scope.productDetail.high);
                            $scope.namePrModel  = $scope.productDetail.name;
                            $scope.priceMdl     = $scope.convertToPriceFormatWithVirgul($scope.productDetail.price_ttc);
                            // init variants
                            var vars = $scope.productDetail.variants;

                                for(var i = 0; i < $scope.variants.length ; i++) {
                                    for(var j =0 ;j < vars.length ; j++) {
                                        if(parseInt(vars[j].id) == parseInt($scope.selectVariants[i].id))
                                            $scope.selectVariants[i].isChecked = true;
                                     }
                                  }

                            // init references
                            var refs = $scope.productDetail.external_references;
                            for(var i = 0; i < refs.length ; i++) {
                                $scope.references.push(
                                    {
                                        client_id : refs[i].id,
                                        client_name : refs[i].pivot.reference_name,
                                        visible : true
                                    })
                            }
                            // init Formules Calcul Prix
                            $scope.priceAttr1 = $scope.productDetail.price_attr1;
                            $scope.priceAttr2 = $scope.productDetail.price_attr2;
                            $scope.priceAttr3 = $scope.productDetail.price_attr3;

                            $('#msgError').hide();
                            $('#divBody').show();
                        } else {
                            $scope.error_response = $scope.getErrorMessage(response);
                            $('#msgError').show();
                            $('#divBody').hide();
                        }

                        $('#divProduct').show();
                    }, function errorCallback(response) {
                        $('#Loaderdiv').hide();
                        $scope.error_response = $scope.getErrorMessage(response);
                        $('#msgError').show();
                        $('#divBody').hide();
                    });
                }
                // Get variants
                function getVariants() {
                    var url = $scope.url+"variants";
                    $http({
                        method: 'GET',
                        url: url,
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {
                        if(response.status == 200) {
                            $scope.variants = response.data;
                            for(var i =0;i < $scope.variants.length; i++) {
                                $scope.selectVariants.push({
                                    id          : $scope.variants[i].id,
                                    ERP_code    : $scope.variants[i].ERP_code,
                                    deactivated : $scope.variants[i].deactivated,
                                    isChecked   : null
                                });
                            }
                        }  else
                            $scope.response_error = "Une erreur s'est produite, merci de réessayer.";

                    }, function errorCallback(response) {

                        $scope.response_error = response.data.message;
                    });
                }

                // Get unit
                function getUnits() {
                    var url = $scope.url+"units";
                    $http({
                        method: 'GET',
                        url: url,
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {
                        if(response.status == 200) {
                            $scope.units = response.data;
                            $scope.unitMdl =  $scope.units[0].id ;
                        } else
                            $scope.response_error = "Une erreur s'est produite, merci de réessayer.";

                    }, function errorCallback(response) {

                        $scope.response_error = response.data.message;
                    });
                }
                // Get client
                function getClients() {
                    var url = $scope.url+"clients";
                    $http({
                        method: 'GET',
                        url: url,
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {
                        if(response.status == 200) {
                            $scope.clients = response.data;
                            //$scope.clientMdl = $scope.clients[0].id;
                        } else
                            $scope.response_error = "Une erreur s'est produite, merci de réessayer.";

                    }, function errorCallback(response) {

                        $scope.response_error = response.data.message;
                    });
                }

                // Get categories
                function getCategories() {
                    var url = $scope.url+"categories";
                    $http({
                        method: 'GET',
                        url: url,
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {

                        if(response.status == 200) {
                            $scope.categories = response.data;
                           // $scope.catMdl = $scope.categories[0].id;
                           // getGroups($scope.catMdl);

                        } else
                            $scope.response_error = "Une erreur s'est produite, merci de réessayer.";
                        $('#Loaderdiv').hide();
                        $('#divParent').show();

                    }, function errorCallback(response) {
                        $scope.response_error = response.data.message;
                        $('#Loaderdiv').hide();
                        $('#divParent').show();
                    });
                }
                // Get groups
                function getGroups(id, idGroup) {
                    var url = $scope.url+"categories/"+id;
                    $http({
                        method: 'GET',
                        url: url,
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {
                        if(response.status == 200) {
                            $scope.groups = response.data.groups;
                            $scope.groupMdl = idGroup;
                        } else
                            $scope.response_error = "Une erreur s'est produite, merci de réessayer.";

                    }, function errorCallback(response) {

                        $scope.response_error = response.data.message;
                    });
                }
                // Get remises
                function getRemises() {
                    var url = $scope.url+"discounts";
                    $http({
                        method: 'GET',
                        url: url,
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {
                        if(response.status == 200) {
                            $scope.remises = response.data;
                            $scope.remiseMdl = 0;
                        } else
                            $scope.response_error = "Une erreur s'est produite, merci de réessayer.";

                    }, function errorCallback(response) {

                        $scope.response_error = response.data.message;
                    });
                }
                // Get remises
                function getRate() {
                    var url = $scope.url+"vats";
                    $http({
                        method: 'GET',
                        url: url,
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {
                        if(response.status == 200) {
                            $scope.rates = response.data;
                            $scope.rateMdl = $scope.rates[0].id;
                        } else
                            $scope.response_error = "Une erreur s'est produite, merci de réessayer.";

                    }, function errorCallback(response) {

                        $scope.response_error = response.data.message;
                    });
                }

                // Get dimensions
                function getDimensions() {
                    var url = $scope.url+"dimensions";
                    $http({
                        method: 'GET',
                        url: url,
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {
                        if(response.status == 200) {
                            $scope.dimensions = response.data;
                        } else
                            $scope.response_error = "Une erreur s'est produite, merci de réessayer.";

                    }, function errorCallback(response) {

                        $scope.response_error = response.data.message;
                    });
                }

                function getProductParams() {
                    var paramsProduct = {};
                    var deactivateProduct           = {deactivated                     : $scope.productDetail.deactivated};
                    var visibleProduct              = {visible_individual              : $scope.productDetail.visible_individual};
                    var horsStandardProduct         = {non_standard                    : $scope.productDetail.non_standard};
                    var isGabaritProduct            = {is_gabarit                      : $scope.productDetail.is_gabarit};
                    var groupProduct                = {group_id                        : $scope.groupMdl};
                    var nameProduct                 = {name                            : $scope.namePrModel};
                    var codeProduct                 = {ERP_code                        : $scope.codeModel};
                    var unitProduct                 = {unit_id                         : $scope.unitMdl};

                    var lengthProduct               = {length                          : $scope.lngMdl};
                    var widthProduct                = {width                           : $scope.lrgMdl};
                    var highProduct                 = {high                            : $scope.htMdl};

                    var priceTTCProduct             = {price_ttc                       : $scope.convertToPriceFormat($scope.priceMdl)};
                    var vatProduct                  = {vat_id                          : $scope.rateMdl};
                    var discountProduct             = {discount_id                     : $scope.remiseMdl};
                    var clientProduct               = {specific_client_id              : $scope.clientMdl};
                    var externalReferencesProduct   = {external_references             : $scope.referencesExt};
                    var variantsProduct             = {variants                        : $scope.variantsChekced};
                    var saisir_longueur              ={saisir_longueur                    : $scope.booleanToInteger($scope.longueurMDL)};
                    var saisir_largeur              ={saisir_largeur                    : $scope.booleanToInteger($scope.largeurMDL)};
                    var saisir_hauteur              ={saisir_hauteur                    : $scope.booleanToInteger($scope.hauteurMDL)};
                    var saisir_dim_supp_1             ={saisir_dim_supp_1                    : $scope.booleanToInteger($scope.dimSupp1MDL)};
                    var saisir_dim_supp_2             ={saisir_dim_supp_2                   : $scope.booleanToInteger($scope.dimSupp2MDL)};
                    var saisir_dim_supp_3            ={saisir_dim_supp_3                   : $scope.booleanToInteger($scope.dimSupp3MDL)};
                    var saisir_dim_supp_4            ={saisir_dim_supp_4                   : $scope.booleanToInteger($scope.dimSupp4MDL)};
                    var saisir_dim_supp_5            ={saisir_dim_supp_5                   : $scope.booleanToInteger($scope.dimSupp5MDL)};
                    var saisir_info_supp_1            ={saisir_info_supp_1                   : $scope.booleanToInteger($scope.infoSupp1MDL)};
                    var saisir_info_supp_2            ={saisir_info_supp_2                   : $scope.booleanToInteger($scope.infoSupp2MDL)};
                    var label_dim_supp_1             ={label_dim_supp_1                  :$scope.ds1Mdl};
                    var label_dim_supp_2            ={label_dim_supp_2                   : $scope.ds2Mdl};
                    var label_dim_supp_3            ={label_dim_supp_3                   : $scope.ds3Mdl};
                    var label_dim_supp_4            ={label_dim_supp_4                   : $scope.ds4Mdl};
                    var label_dim_supp_5            ={label_dim_supp_5                   : $scope.ds5Mdl};
                    var label_info_supp_1           ={label_info_supp_1                  : $scope.info1Mdl};
                    var label_info_supp_2           ={label_info_supp_2                  : $scope.info2Mdl};
                    var price_attr1                 = {price_attr1                     : $scope.priceAttr1};
                    var price_attr2                 = {price_attr2                     : $scope.priceAttr2};
                    var price_attr3                 = {price_attr3                     : $scope.priceAttr3};

                    paramsProduct = angular.extend({},paramsProduct, deactivateProduct)
                    paramsProduct = angular.extend({},paramsProduct, visibleProduct)
                    paramsProduct = angular.extend({},paramsProduct, horsStandardProduct)
                    paramsProduct = angular.extend({},paramsProduct, isGabaritProduct)
                    paramsProduct = angular.extend({},paramsProduct, saisir_longueur )
                    paramsProduct = angular.extend({},paramsProduct, saisir_largeur )
                    paramsProduct = angular.extend({},paramsProduct, saisir_hauteur )
                    paramsProduct = angular.extend({},paramsProduct, saisir_dim_supp_1)
                    paramsProduct = angular.extend({},paramsProduct, saisir_dim_supp_2)
                    paramsProduct = angular.extend({},paramsProduct, saisir_dim_supp_3)
                    paramsProduct = angular.extend({},paramsProduct, saisir_dim_supp_4)
                    paramsProduct = angular.extend({},paramsProduct, saisir_dim_supp_5)
                    paramsProduct = angular.extend({},paramsProduct, saisir_info_supp_1)
                    paramsProduct = angular.extend({},paramsProduct, saisir_info_supp_2)

                    if($scope.groupMdl != null)
                        paramsProduct = angular.extend({},paramsProduct, groupProduct)
                    if($scope.namePrModel != null)
                        paramsProduct = angular.extend({},paramsProduct, nameProduct)
                    if($scope.codeModel != null)
                        paramsProduct = angular.extend({},paramsProduct, codeProduct)
                    if($scope.unitMdl != null)
                        paramsProduct = angular.extend({},paramsProduct, unitProduct)
                   // if($scope.lngMdl!= null)
                        paramsProduct = angular.extend({},paramsProduct, lengthProduct)
                    //if($scope.lrgMdl != null)
                        paramsProduct = angular.extend({},paramsProduct, widthProduct)
                    //if($scope.htMdl != null)
                        paramsProduct = angular.extend({},paramsProduct, highProduct)
                    if($scope.priceMdl != null)
                        paramsProduct = angular.extend({},paramsProduct, priceTTCProduct)
                    if($scope.rateMdl != null)
                        paramsProduct = angular.extend({},paramsProduct, vatProduct)
                    if($scope.remiseMdl > 0)
                        paramsProduct = angular.extend({},paramsProduct, discountProduct)
                    if($scope.clientMdl != null)
                        paramsProduct = angular.extend({},paramsProduct, clientProduct)
                    //if($scope.variantsChekced.length > 0)
                        paramsProduct = angular.extend({},paramsProduct, variantsProduct)
                    //if($scope.referencesExt.length > 0)
                        paramsProduct = angular.extend({},paramsProduct, externalReferencesProduct)
                    paramsProduct = angular.extend({},paramsProduct, label_dim_supp_1)
                    paramsProduct = angular.extend({},paramsProduct, label_dim_supp_2)
                    paramsProduct = angular.extend({},paramsProduct, label_dim_supp_3)
                    paramsProduct = angular.extend({},paramsProduct, label_dim_supp_4)
                    paramsProduct = angular.extend({},paramsProduct, label_dim_supp_5)
                    paramsProduct = angular.extend({},paramsProduct, label_info_supp_1)
                    paramsProduct = angular.extend({},paramsProduct, label_info_supp_2)
                    paramsProduct = angular.extend({},paramsProduct, price_attr1)
                    paramsProduct = angular.extend({},paramsProduct, price_attr2)
                    paramsProduct = angular.extend({},paramsProduct, price_attr3)

                    return paramsProduct;
                }
                $scope.variantsChekced = [];
                // prepare varaiants
                function prepareVariants() {
                    for(var i =0;i < $scope.selectVariants.length; i++) {
                        if( $scope.selectVariants[i].isChecked != null &&  $scope.selectVariants[i].isChecked){
                            $scope.variantsChekced.push({
                                variant_id       : $scope.selectVariants[i].id
                            });
                        }
                    }
                }
                $scope.updateProduit = function () {
                    $('#msgBottom').hide();
                    $('#LoaderdivBottom').show();
                    prepareReferences();
                    prepareVariants();
                    var url = $scope.url+"products/"+$scope.getCoockie('parmsID');
                    $http({
                        method: 'PUT',
                        url: url,
                        //data: $.param(getProductParams()),
                        data: JSON.stringify(getProductParams()),
                        headers: {
                            //"Content-Type": "application/x-www-form-urlencoded",
                            "Content-Type": "application/json",
                            "Authorization" : $scope.userSession()
                        }
                    }).then(function successCallback(response) {
                        if(response.status == 200) {
                            window.location.replace('/#/catalogue/produits');
                        } else {
                            $('#msgBottom').show();
                            $('#LoaderdivBottom').hide();
                            $scope.error_update_produit = $scope.getErrorMessage(response);
                        }

                    }, function errorCallback(response) {
                        $('#msgBottom').show();
                        $('#LoaderdivBottom').hide();
                        $scope.error_update_produit = $scope.getErrorMessage(response);

                    });
                }
                // prepare external references
                function prepareReferences() {
                    $scope.referencesExt = [];
                    for (var i = 0; i<$scope.references.length; i++){
                        if($scope.references[i].visible)
                        $scope.referencesExt.push({client_id : $scope.references[i].client_id,reference_name : $scope.references[i].client_name})
                    }
                }
                getVariants();
                getUnits();
                getClients();
                getCategories();
                getRemises();
                getRate();
                getProduct();
                getDimensions();
                $scope.checkDeactivate = function() {
                    if ($scope.productDetail.deactivated == 0)
                        $scope.productDetail.deactivated = 1;
                    else
                        $scope.productDetail.deactivated = 0;
                }
                $scope.checkVisible = function() {
                    if ($scope.productDetail.visible_individual == 0)
                        $scope.productDetail.visible_individual = 1;
                    else
                        $scope.productDetail.visible_individual = 0;
                }
                $scope.checkHorsStandard = function() {
                    if ($scope.productDetail.non_standard == 0)
                        $scope.productDetail.non_standard = 1;
                    else {
                        $scope.productDetail.non_standard = 0;
                        $scope.productDetail.is_gabarit = 0;
                    }
                }
                $scope.checkIsGabarit = function() {
                    if ($scope.productDetail.is_gabarit == 0)
                        $scope.productDetail.is_gabarit = 1;
                    else
                        $scope.productDetail.is_gabarit = 0;
                }
                $scope.checklgt = function(val) {
                    if(val==true){
                        $('#lngMdl').val("");
                        $scope.lngMdl=null;
                    }
                    $scope.longueurMDL = val ;
                }
                $scope.checklarg = function(val) {
                    if(val==true){
                        $('#lrgMdl').val("");
                        $scope.lrgMdl=null;
                    }
                    $scope.largeurMDL = val ;
                }
                $scope.checkhat = function(val) {
                    if(val==true){
                        $('#htMdl').val("");
                        $scope.htMdl=null;
                    }
                    $scope.hauteurMDL = val ;
                }
                $scope.checkDs1 = function(val) {
                    $scope.ds1Mdl = val ;
                }
                $scope.checkinfo1 = function(val) {
                    $scope.info1Mdl = val ;
                }
                $scope.checkinfo2 = function(val) {
                    $scope.info2Mdl = val ;
                }
                $scope.checkInfobox1 = function(val) {
                    if(val==false){
                        $('#info1Mdl').val("");
                        $scope.info1Mdl=null;
                    }
                    $scope.infoSupp1MDL = val ;
                }
                $scope.checkInfobox2 = function(val) {
                    if(val==false){
                        $('#info2Mdl').val("");
                        $scope.info2Mdl=null;
                    }
                    $scope.infoSupp2MDL = val ;
                }
                $scope.checkDs2 = function(val) {
                    $scope.ds2Mdl = val ;
                }
                $scope.checkDs3 = function(val) {
                    $scope.ds3Mdl = val ;
                }
                $scope.checkDs4 = function(val) {
                    $scope.ds4Mdl = val ;
                }
                $scope.checkDs5 = function(val) {
                    $scope.ds5Mdl = val ;
                }
                $scope.checkDim3 = function(val) {
                    if(val==false){
                        $('#ds3Mdl').val("");
                        $scope.ds3Mdl=null;
                    }
                    $scope.dimSupp3MDL = val ;
                }
                $scope.checkDim1 = function(val) {
                    if(val==false){
                        $('#ds1Mdl').val("");
                        $scope.ds1Mdl=null;
                    }
                    $scope.dimSupp1MDL = val ;
                }
                $scope.checkDim2 = function(val) {
                    if(val==false){
                        $('#ds2Mdl').val("");
                        $scope.ds2Mdl=null;
                    }
                    $scope.dimSupp2MDL = val ;
                }
                $scope.checkDim4 = function(val) {
                    if(val==false){
                        $('#ds4Mdl').val("");
                        $scope.ds4Mdl=null;
                    }
                    $scope.dimSupp4MDL = val ;
                }
                $scope.checkDim5 = function(val) {
                    if(val==false){
                        $('#ds5Mdl').val("");
                        $scope.ds5Mdl=null;
                    }
                    $scope.dimSupp5MDL = val ;
                }
                $scope.checkStandard = function(val) {
                    $scope.standardMDL = val ;
                }
                $scope.checkCode = function(val) {
                    $scope.codeModel = val ;
                }
                $scope.checkUnit = function(val) {
                    $scope.unitMdl = val ;
                }
                $scope.checkLng = function(val) {
                    $scope.lngMdl = val ;
                }
                $scope.checkLrg = function(val) {
                    $scope.lrgMdl = val ;
                }
                $scope.checkHt = function(val) {
                    $scope.htMdl = val ;
                }
                $scope.checkNamePr = function(val) {
                    $scope.namePrModel = val ;
                }

                $scope.checkClient = function(val) {
                    $scope.clientMdl = val ;
                }
                $scope.checkCategory = function(val) {
                    $scope.catMdl = val ;
                    getGroups($scope.catMdl);

                }

                $scope.checkGroup = function(val) {
                    $scope.groupMdl = val ;
                }
                $scope.checkRemise = function(val) {
                    $scope.remiseMdl = val ;
                }
                $scope.checkRate = function(val) {
                    $scope.rateMdl = val ;
                }

                $scope.checkPrice = function(val) {
                    $scope.priceMdl = val ;
                }

                $scope.checkPriceAttr1 = function(val) {
                    $scope.priceAttr1 = val != '' ? val : null;
                }
                $scope.checkPriceAttr2 = function(val) {
                    $scope.priceAttr2 = val != '' ? val : null;
                }
                $scope.checkPriceAttr3 = function(val) {
                    $scope.priceAttr3 = val != '' ? val : null;
                }
            }
        });
    }

})();