/**
 * Created by majid on 07/02/2017.
 */
(function () {
    'use strict';

    angular.module('BlurAdmin.pages.alertes.referencesExternes', [])
        .config(routeConfig);

    /** @ngInject */
    function routeConfig($stateProvider) {
        $stateProvider
            .state('alertes.referencesExternes', {
                url: '/referencesExternes',
                templateUrl: 'app/pages/alertes/referencesExternes/referencesExternes.html',
                title: 'References Externes',
                sidebarMeta: {
                    icon: 'ion-android-home',
                    order: 200,
                },
                controller: function ($scope, $stateParams, $http, $state) {
                    if (!$scope.isLogged())
                        window.location.replace(' /#/login');

                    $('#divTable').hide();
                    $('#Loaderdiv').show();
                    $('#msgBottom').hide();

                    $scope.referencesExternesMissing          = [];
                    $scope.totalReferencesMissing             = 0;
                    $scope.refersPerPage                      = 25;

                    $scope.pagination = {
                        current: 1
                    };
                    $scope.pageChanged = function(newPage) {
                        getReferencesMissingses(newPage);
                    };
                    function getReferencesMissingses(pageNumber) {
                        var url = $scope.url+"externalReferencesMissings?pagination_per_page=25&page="+pageNumber;
                        $http({
                            method: 'GET',
                            url: url,
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded",
                                "Authorization" : $scope.userSession()
                            }
                        }).then(function successCallback(response) {
                            $('#Loaderdiv').hide();
                            $('#divTable').show();
                            if(response.status == 200) {
                                $scope.referencesExternesMissing = response.data.data;
                                $scope.totalReferencesMissing = response.data.total;
                            } else {
                                $('#divTable').hide();
                                $('#msgBottom').show();
                                $scope.error_ref_missing = $scope.getErrorMessage(response);
                            }
                        }, function errorCallback(response) {
                            $('#Loaderdiv').hide();
                            $('#divTable').hide();
                            $('#msgBottom').show();
                            $scope.error_ref_missing = $scope.getErrorMessage(response);
                        });
                    }
                    getReferencesMissingses(1);
                }
            });
    }
})();